<?php
namespace ETC\App\Models\Widgets;

use ETC\App\Models\WC_Widget;

/**
 * Stock Status filter Widget.
 *
 * @since      3.0.3
 * @package    ETC
 * @subpackage ETC/Models/Widgets
 */
class Product_Status_Filter extends WC_Widget {
	function __construct() {
		$this->widget_cssclass    = 'sidebar-widget etheme-product-status-filter';
		$this->widget_description = esc_html__( 'Widget to filtering products by stock attribute', 'xstore-core' );
		$this->widget_id          = 'etheme_product_status_filter';
		$this->widget_name        = '8theme - ' . esc_html__( 'Product Status Filters', 'xstore-core' );
		$this->settings           = array(
			'title' => array(
				'type'  => 'text',
				'std'   => esc_html__( 'Product Status', 'xstore-core' ),
				'label' => esc_html__( 'Title', 'xstore-core' ),
			),
		);
		parent::__construct();
		add_action( 'woocommerce_product_query', array( $this, 'show_in_stock_products' ) );
		add_filter( 'loop_shop_post_in', array( $this, 'show_on_sale_products' ) );
	}

	function widget($args, $instance) {
		$link  = $this->get_current_page_url();
		$class = $in_stock_class = $out_of_stock_class = '';
		$sale_link = $in_stock = $out_of_stock = $link;


		if (! isset($_GET['stock_status'])){
			$out_of_stock = add_query_arg( 'stock_status', 'out_of_stock', $link );
		} else {
			if ($_GET['stock_status']=='in_stock'){
				$out_of_stock = add_query_arg( 'stock_status', 'out_of_stock,in_stock', $link );
			} elseif($_GET['stock_status']=='out_of_stock,in_stock'){
				$out_of_stock = add_query_arg( 'stock_status', 'in_stock', $link );
				$out_of_stock_class = 'chosen';
			} else {
				$out_of_stock = remove_query_arg( 'stock_status', $link );
				$out_of_stock_class = 'chosen';
			}
		}

		if (! isset($_GET['stock_status'])){
			$in_stock = add_query_arg( 'stock_status', 'in_stock', $link );
		} else {
			if ($_GET['stock_status']=='out_of_stock'){
				$in_stock = add_query_arg( 'stock_status', 'out_of_stock,in_stock', $link );
			}elseif($_GET['stock_status']=='out_of_stock,in_stock'){
				$in_stock = add_query_arg( 'stock_status', 'out_of_stock', $link );
				$in_stock_class = 'chosen';
			}else {
				$in_stock = remove_query_arg( 'stock_status', $link );
				$in_stock_class = 'chosen';
			}
		}

		if (! isset($_GET['sale_status'])){
			$sale_link = add_query_arg( 'sale_status', true, $link );
		} else {
			$sale_link = remove_query_arg( 'sale_status', $link );
			$class = 'chosen';
		}
		$this->widget_start( $args, $instance );
		?>
			<ul>
				<li class="<?php echo $in_stock_class; ?>"><a href="<?php echo $in_stock; ?>" class="etheme-ajax-filter etheme-stock-filter"><?php echo esc_html__( 'In stock', 'xstore-core' ); ?></a></li>
				<li class="<?php echo $out_of_stock_class; ?>"><a href="<?php echo $out_of_stock; ?>" class="etheme-ajax-filter etheme-stock-filter"><?php echo esc_html__( 'Out of stock', 'xstore-core' ); ?></a></li>
				<li class="<?php echo $class; ?>"><a href="<?php echo $sale_link; ?>" class="etheme-ajax-filter etheme-sale-filter"><?php echo esc_html__( 'On sale', 'xstore-core' ) ?></a></li>
			</ul>
        <?php
		$this->widget_end( $args, $instance );
	}

	public function show_on_sale_products( $ids ) {
		if ( isset( $_GET['sale_status'] ) && $_GET['sale_status'] ) {
			$ids = array_merge( $ids, wc_get_product_ids_on_sale() );
		}
		return $ids;
	}

	public function show_in_stock_products( $query ) {
		if ( isset( $_GET['stock_status'] ) && $_GET['stock_status'] ) {
			$meta_query = array();
		    if ($_GET['stock_status'] == 'in_stock'){
			    $meta_query = array(
				    'relation' => 'AND',
				    array(
					    'key'     => '_stock_status',
					    'value'   => 'instock',
					    'compare' => '=',
				    ),
			    );
		    } elseif ($_GET['stock_status'] == 'out_of_stock'){
			    $meta_query = array(
				    'relation' => 'AND',
				    array(
					    'key'     => '_stock_status',
					    'value'   => 'outofstock',
					    'compare' => '=',
				    ),
			    );
		    }
			$query->set( 'meta_query', array_merge( WC()->query->get_meta_query(), $meta_query ) );
		}
	}
}
