<?php
// section mobile_panel

Kirki::add_panel( 'sales-booster', array(
	'title' => esc_html__( 'Sales Booster', 'xstore-core' ),
	'icon' => 'dashicons-money-alt',//dashicons-products
	'priority' => 6
) );

		Kirki::add_section( 'progress-bar', array(
			'title' => esc_html__( 'Progress Bar', 'xstore-core' ),
			'icon' => 'dashicons-chart-bar',
			'panel' => 'sales-booster',
		) );

		// booster_progress_bar
		Kirki::add_field( 'et_kirki_options', array(
			'type'        => 'toggle',
			'settings'    => 'booster_progress_bar_et-desktop',
			'label'       => esc_html__( 'Progress bar', 'xstore-core' ),
			'section'     => 'progress-bar',
			'default'     => 0,
		) );

		// booster_progress_content
		Kirki::add_field( 'et_kirki_options', array(
			'type'        => 'textarea',
			'settings'    => 'booster_progress_content_et-desktop',
			'label'       => esc_html__( 'Progress message text', 'xstore-core' ),
			'description' => esc_html__('Write your text for progress bar using {{et_price}} to replace with scripts', 'xstore-core'),
			'section'     => 'progress-bar',
			'default'     => 'Spend {{et_price}} to get free shipping',
			'transport' => 'postMessage',
			'active_callback' => array(
				array(
					'setting'  => 'booster_progress_bar_et-desktop',
					'operator' => '!=',
					'value'    => 0,
				),
			),
			'partial_refresh' => array(
				'booster_progress_content_et-desktop' => array(
					'selector'  => '.et-cart-progress-bar',
					'render_callback' => function() {
						if(class_exists('WPBMap') && method_exists('WPBMap', 'addAllMappedShortcodes'))
							WPBMap::addAllMappedShortcodes();
						$content = get_theme_mod('booster_progress_content_et-desktop' , 'Spend {{et_price}} to get free shipping');
						return do_shortcode($content);
					},
				),
			),
		) );
		
		// booster_progress_icon
		Kirki::add_field( 'et_kirki_options', array(
			'type'        => 'select',
			'settings'    => 'booster_progress_icon_et-desktop',
			'label'       => esc_html__( 'Icon for process content', 'xstore-core' ),
			'section'     => 'progress-bar',
			'choices'     =>  $icons['simple'],
			'default'     => 'et_icon-delivery',
			'active_callback' => array(
				array(
					'setting'  => 'booster_progress_bar_et-desktop',
					'operator' => '!=',
					'value'    => 0,
				),
			),
		) );
		
		// booster_progress_icon_position
		Kirki::add_field( 'et_kirki_options', array(
			'type'        => 'select',
			'settings'    => 'booster_progress_icon_position_et-desktop',
			'label'       => esc_html__( 'Icon position', 'xstore-core' ),
			'section'     => 'account',
			'default'     => 'solid',
			'choices'     => $choices['border_style'],
			'active_callback' => array(
				array(
					'setting'  => 'booster_progress_bar_et-desktop',
					'operator' => '!=',
					'value'    => 0,
				),
				array(
					'setting'  => 'booster_progress_icon_et-desktop',
					'operator' => '!=',
					'value'    => 'none',
				),
			),
		) );

		Kirki::add_field( 'et_kirki_options', array(
			'type'        => 'text',
			'settings'    => 'booster_progress_price_et-desktop',
			'label'       => esc_html__( 'Price {{et_price}} for count', 'xstore-core' ),
			'description' => esc_html__( 'Enter only numbers. Do not enter currency symbol!', 'xstore-core' ),
			'section'     => 'progress-bar',
			'default'     => 350,
			'active_callback' => array(
				array(
					'setting'  => 'booster_progress_bar_et-desktop',
					'operator' => '!=',
					'value'    => 0,
				),
			),
		) );

		Kirki::add_field( 'et_kirki_options', array(
			'type'        => 'textarea',
			'settings'    => 'booster_progress_content_success_et-desktop',
			'label'       => esc_html__( 'Progress message success text', 'xstore-core' ),
			'section'     => 'progress-bar',
			'default'     => 'Congratulations! You\'ve got free shipping.',
			'transport' => 'postMessage',
			'active_callback' => array(
				array(
					'setting'  => 'booster_progress_bar_et-desktop',
					'operator' => '!=',
					'value'    => 0,
				),
			),
			'partial_refresh' => array(
				'booster_progress_content_success_et-desktop' => array(
					'selector'  => '.et-cart-progress-bar',
					'render_callback' => function() {
						if(class_exists('WPBMap') && method_exists('WPBMap', 'addAllMappedShortcodes'))
							WPBMap::addAllMappedShortcodes();
						$content = get_theme_mod('booster_progress_content_success_et-desktop' , 'Congratulations! You\'ve got free shipping.');
						return do_shortcode($content);
					},
				),
			),
		) );

		Kirki::add_field( 'et_kirki_options', array(
			'type'        => 'select',
			'settings'    => 'booster_progress_success_icon_et-desktop',
			'label'       => esc_html__( 'Success Icon', 'xstore-core' ),
			'section'     => 'progress-bar',
			'choices'     =>  $icons['simple'],
			'default'     => 'et_icon-star',
			'active_callback' => array(
				array(
					'setting'  => 'booster_progress_bar_et-desktop',
					'operator' => '!=',
					'value'    => 0,
				),
			),
		) );

		Kirki::add_field( 'et_kirki_options', array(
			'type'        => 'select',
			'settings'    => 'booster_progress_success_icon_position_et-desktop',
			'label'       => esc_html__( 'Success Icon position', 'xstore-core' ),
			'section'     => 'progress-bar',
			'default'     => 'before',
			'choices'     => array(
				'before' => esc_html__('Before', 'xstore-core'),
				'after' => esc_html__('After', 'xstore-core'),
			),
			'active_callback' => array(
				array(
					'setting'  => 'booster_progress_bar_et-desktop',
					'operator' => '!=',
					'value'    => 0,
				),
				array(
					'setting'  => 'booster_progress_success_icon_et-desktop',
					'operator' => '!=',
					'value'    => 'none',
				),
			),
		) );