<?php if ( ! defined( 'ABSPATH' ) ) {
	exit( 'No direct script access allowed' );
}
/**
 * Declare et_icons/et_social_icons
 *
 * @since   1.0.0
 * @version 1.0.2
 */
global $et_icons, $et_social_icons, $et_cart_icons, $et_wishlist_icons, $et_account_icons;

$et_icons = array(
	'light' => array(
		'et_icon-delivery'        => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.448 7.248h-3.24v-1.032c0-0.528-0.432-0.96-0.96-0.96h-11.784c-0.528 0-0.96 0.432-0.96 0.96v2.304h-3.048c0 0 0 0 0 0-0.192 0-0.384 0.096-0.48 0.264l-1.56 2.736h-0.864c-0.312 0-0.552 0.24-0.552 0.552v4.416c0 0.288 0.24 0.552 0.552 0.552h1.032c0.264 1.032 1.176 1.728 2.208 1.728 0.144 0 0.288-0.024 0.432-0.048 0.888-0.168 1.584-0.816 1.8-1.68h1.032c0.048 0 0.12-0.024 0.168-0.024 0.072 0.024 0.168 0.024 0.24 0.024h5.040c0.288 1.176 1.44 1.92 2.64 1.68 0.888-0.168 1.584-0.816 1.8-1.68h2.328c0.528 0 0.96-0.432 0.96-0.96v-3.48h2.4c0.312 0 0.552-0.24 0.552-0.552s-0.24-0.552-0.552-0.552h-2.4v-1.032h0.288c0.312 0 0.552-0.24 0.552-0.552s-0.24-0.552-0.552-0.552h-0.288v-1.032h3.24c0.312 0 0.552-0.24 0.552-0.552-0.024-0.288-0.264-0.528-0.576-0.528zM16.848 7.8c0 0.312 0.24 0.552 0.552 0.552h1.728v1.032h-4.68c-0.312 0-0.552 0.24-0.552 0.552s0.24 0.552 0.552 0.552h4.656v1.032h-2.568c-0.144 0-0.288 0.048-0.384 0.168-0.096 0.096-0.168 0.24-0.168 0.384 0 0.312 0.24 0.552 0.552 0.552h2.544v3.312h-2.16c-0.144-0.552-0.456-1.008-0.936-1.344-0.504-0.336-1.104-0.48-1.704-0.36-0.888 0.168-1.584 0.816-1.8 1.68l-4.92-0.024 0.024-9.552 11.496 0.024v0.888h-1.728c-0.264 0-0.504 0.24-0.504 0.552zM14.712 15.288c0.648 0 1.2 0.528 1.2 1.2 0 0.648-0.528 1.2-1.2 1.2-0.648 0-1.2-0.528-1.2-1.2 0.024-0.672 0.552-1.2 1.2-1.2zM3.792 15.288c0.648 0 1.2 0.528 1.2 1.2 0 0.648-0.528 1.2-1.2 1.2s-1.2-0.528-1.2-1.2c0.024-0.672 0.552-1.2 1.2-1.2zM6.48 12.6v3.312h-0.48c-0.144-0.552-0.456-1.008-0.936-1.344-0.504-0.336-1.104-0.48-1.704-0.36-0.888 0.168-1.584 0.816-1.8 1.68h-0.48v-3.288h5.4zM6.48 9.624v1.896h-3.792l1.080-1.872h2.712z"></path></svg>',
		'et_icon-coupon'          => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.5 9.5c0.276 0 0.5-0.224 0.5-0.5v-4c0-0.276-0.224-0.5-0.5-0.5h-23c-0.276 0-0.5 0.224-0.5 0.5v4c0 0.276 0.224 0.5 0.5 0.5 1.379 0 2.5 1.122 2.5 2.5s-1.121 2.5-2.5 2.5c-0.276 0-0.5 0.224-0.5 0.5v4c0 0.276 0.224 0.5 0.5 0.5h23c0.276 0 0.5-0.224 0.5-0.5v-4c0-0.276-0.224-0.5-0.5-0.5-1.379 0-2.5-1.122-2.5-2.5s1.121-2.5 2.5-2.5zM20 12c0 1.76 1.306 3.221 3 3.464v3.036h-22v-3.036c1.694-0.243 3-1.704 3-3.464s-1.306-3.221-3-3.464v-3.036h22v3.036c-1.694 0.243-3 1.704-3 3.464zM6.5 10.5c-0.276 0-0.5 0.224-0.5 0.5v2c0 0.276 0.224 0.5 0.5 0.5s0.5-0.224 0.5-0.5v-2c-0-0.276-0.224-0.5-0.5-0.5zM6.5 6.5c-0.276 0-0.5 0.224-0.5 0.5v2c0 0.276 0.224 0.5 0.5 0.5s0.5-0.224 0.5-0.5v-2c-0-0.276-0.224-0.5-0.5-0.5zM6.5 14.5c-0.276 0-0.5 0.224-0.5 0.5v2c0 0.276 0.224 0.5 0.5 0.5s0.5-0.224 0.5-0.5v-2c-0-0.276-0.224-0.5-0.5-0.5zM17.5 10.5c-0.276 0-0.5 0.224-0.5 0.5v2c0 0.276 0.224 0.5 0.5 0.5s0.5-0.224 0.5-0.5v-2c0-0.276-0.224-0.5-0.5-0.5zM17.5 6.5c-0.276 0-0.5 0.224-0.5 0.5v2c0 0.276 0.224 0.5 0.5 0.5s0.5-0.224 0.5-0.5v-2c0-0.276-0.224-0.5-0.5-0.5zM17.5 14.5c-0.276 0-0.5 0.224-0.5 0.5v2c0 0.276 0.224 0.5 0.5 0.5s0.5-0.224 0.5-0.5v-2c0-0.276-0.224-0.5-0.5-0.5z"></path></svg>',
		'et_icon-calendar'        => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M22.56 1.68h-2.568v-1.032c0-0.264-0.24-0.576-0.576-0.576h-2.76c-0.264 0-0.576 0.24-0.576 0.576v1.032h-8.28v-1.032c0-0.264-0.24-0.576-0.576-0.576h-2.712c-0.264 0-0.576 0.24-0.576 0.576v1.032h-2.496c-0.264 0-0.552 0.24-0.552 0.576v21.096c0 0.264 0.24 0.576 0.576 0.576h21.096c0.264 0 0.576-0.24 0.576-0.576v-21.12c-0.024-0.312-0.264-0.552-0.576-0.552zM22.032 7.080v15.72h-20.016v-15.72h20.016zM5.136 3.24v-2.040h1.632v2.064h-1.632zM17.232 3.24v-2.040h1.632v2.064h-1.632zM4.608 4.392h2.76c0.264 0 0.576-0.24 0.576-0.576v-1.032h8.256v1.032c0 0.264 0.24 0.576 0.576 0.576h2.736c0.264 0 0.576-0.24 0.576-0.576v-1.032h1.992v3.216h-20.064v-3.216h2.040v1.032c-0.024 0.264 0.216 0.576 0.552 0.576zM19.584 9.096h-15.168v11.664h15.192v-11.664zM18.48 17.232v2.424h-2.424v-2.424h2.424zM18.48 13.704v2.448h-2.424v-2.448h2.424zM18.48 10.176v2.448h-2.424v-2.448h2.424zM14.976 17.232v2.424h-2.4v-2.424h2.4zM14.976 13.704v2.448h-2.4v-2.448h2.4zM14.976 10.176v2.448h-2.4v-2.448h2.4zM9.024 12.624v-2.448h2.424v2.448h-2.424zM9.024 16.152v-2.448h2.424v2.448h-2.424zM11.448 17.232v2.424h-2.424v-2.424h2.424zM7.92 17.232v2.424h-2.424v-2.424h2.424zM7.944 13.704v2.448h-2.424v-2.448h2.424zM7.944 10.176v2.448h-2.424v-2.448h2.424z"></path></svg>',
		'et_icon-compare'         => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M22.32 6.12c0.216-0.936 0.672-2.808 0.792-3.744 0.048-0.384-0.048-0.648-0.408-0.744-0.384-0.12-0.624 0.072-0.792 0.504-0.216 0.576-0.576 2.472-0.576 2.472-1.56-2.016-3.936-3.552-6.528-4.2l-0.096-0.024c-3.096-0.744-6.24-0.192-8.928 1.416-5.352 3.264-6.816 9.504-5.064 14.256 0.072 0.168 0.264 0.312 0.48 0.36 0.168 0.048 0.336-0.024 0.456-0.072l0.024-0.024c0.312-0.144 0.456-0.504 0.288-0.888-1.536-4.392 0-9.744 4.656-12.504 2.352-1.392 5.040-1.824 7.824-1.152 2.088 0.504 4.296 1.776 5.664 3.6 0 0-1.92 0-2.568 0.024-0.48 0-0.72 0.12-0.792 0.456-0.096 0.36 0.096 0.744 0.456 0.768 1.176 0.072 4.248 0.096 4.248 0.096 0.12 0 0.144 0 0.288-0.024s0.312-0.144 0.408-0.264c0.072-0.12 0.168-0.312 0.168-0.312zM1.608 17.952c-0.216 0.936-0.648 2.808-0.792 3.744-0.048 0.384 0.048 0.648 0.408 0.744 0.384 0.096 0.624-0.096 0.792-0.528 0.216-0.576 0.576-2.472 0.576-2.472 1.56 2.016 3.96 3.552 6.552 4.2l0.096 0.024c3.096 0.744 6.24 0.192 8.928-1.416 5.352-3.24 6.816-9.504 5.064-14.256-0.072-0.168-0.264-0.312-0.48-0.36-0.168-0.048-0.336 0.024-0.456 0.072l-0.024 0.024c-0.312 0.144-0.456 0.504-0.288 0.888 1.536 4.392 0 9.744-4.656 12.504-2.352 1.392-5.040 1.824-7.824 1.152-2.088-0.504-4.296-1.776-5.664-3.6 0 0 1.92 0 2.568-0.024 0.48 0 0.72-0.12 0.792-0.456 0.096-0.36-0.096-0.744-0.456-0.768-1.176-0.072-4.248-0.096-4.248-0.096-0.12 0-0.144 0-0.288 0.024s-0.312 0.144-0.408 0.264c-0.072 0.12-0.192 0.336-0.192 0.336z"></path></svg>',
		'et_icon-checked'         => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0c-6.624 0-12 5.376-12 12s5.376 12 12 12 12-5.376 12-12-5.376-12-12-12zM12 22.728c-5.904 0-10.728-4.8-10.728-10.728s4.824-10.728 10.728-10.728 10.728 4.8 10.728 10.728-4.824 10.728-10.728 10.728zM18.312 7.848c-0.168-0.024-0.36 0.048-0.48 0.168l-7.608 7.368-4.056-4.176c-0.12-0.12-0.312-0.192-0.504-0.192-0.168 0-0.336 0.072-0.432 0.216-0.24 0.288-0.24 0.696 0 0.888l4.512 4.656c0.12 0.12 0.288 0.192 0.456 0.192s0.312-0.072 0.432-0.192l8.040-7.824c0.12-0.12 0.192-0.312 0.192-0.504 0-0.168-0.072-0.312-0.192-0.408-0.072-0.12-0.216-0.192-0.36-0.192z"></path></svg>',
		'et_icon-chat'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M21.288 0.528h-18.6c-1.44 0-2.64 1.176-2.64 2.64v12.744c0 1.44 1.176 2.64 2.64 2.64h2.52l2.256 4.56c0.096 0.216 0.336 0.384 0.6 0.384 0.24 0 0.456-0.12 0.6-0.36l2.256-4.536h10.368c1.44 0 2.64-1.176 2.64-2.64v-12.792c0-1.44-1.176-2.64-2.64-2.64zM22.632 3.168v12.744c0 0.72-0.576 1.296-1.296 1.296h-10.824c-0.264 0-0.504 0.144-0.6 0.36l-1.848 3.696-1.848-3.696c-0.096-0.216-0.336-0.384-0.6-0.384h-2.928c-0.696 0-1.272-0.576-1.272-1.272v-12.744c0-0.72 0.576-1.296 1.296-1.296h18.624c0.72 0 1.296 0.576 1.296 1.296z"></path></svg>',
		'et_icon-phone'           => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M22.080 16.488c-3.504-2.808-4.776-1.44-6.144 0l-0.24 0.24c-0.24 0.216-0.936 0-1.752-0.528-0.912-0.6-2.040-1.584-3.288-2.832-4.128-4.152-3.384-5.016-3.336-5.040l0.24-0.24c1.416-1.392 2.736-2.688-0.072-6.144-0.936-1.152-1.872-1.728-2.832-1.776-1.368-0.096-2.496 1.080-3.336 1.968-0.12 0.144-0.264 0.288-0.408 0.432-1.032 1.008-1.056 3.192-0.048 5.832 1.056 2.832 3.192 5.952 6 8.736 2.76 2.76 5.856 4.896 8.736 6 1.32 0.504 2.496 0.744 3.504 0.744 1.032 0 1.848-0.264 2.328-0.744 0.144-0.12 0.312-0.264 0.456-0.432 0.912-0.864 2.040-1.944 1.992-3.36-0.024-0.96-0.624-1.896-1.8-2.856zM6.744 7.224l-0.24 0.24c-1.128 1.152-0.096 3.216 3.384 6.672 1.344 1.344 2.496 2.328 3.48 2.976 1.44 0.936 2.52 1.056 3.192 0.36l0.264-0.264c1.296-1.296 1.944-1.944 4.584 0.168 0.888 0.72 1.344 1.368 1.368 1.968 0.024 0.912-0.936 1.8-1.632 2.448-0.192 0.144-0.336 0.312-0.48 0.456-0.672 0.648-2.544 0.552-4.656-0.24-2.64-0.984-5.616-3-8.328-5.712-2.688-2.592-4.704-5.544-5.76-8.28-0.768-2.136-0.864-4.008-0.216-4.632 0.072-0.072 0.144-0.168 0.216-0.24s0.144-0.144 0.216-0.24c0.744-0.816 1.56-1.632 2.4-1.632h0.072c0.624 0.024 1.272 0.48 1.968 1.344 2.136 2.664 1.44 3.36 0.168 4.608zM19.008 10.104c0.096 0.048 0.168 0.048 0.24 0.048 0.24 0 0.432-0.144 0.528-0.36 0.648-1.584 0.264-3.408-0.96-4.632-1.248-1.248-3.168-1.608-4.8-0.888-0.144 0.048-0.264 0.168-0.312 0.312s-0.048 0.312 0 0.432c0.048 0.144 0.168 0.264 0.312 0.312s0.312 0.048 0.456-0.024c1.176-0.528 2.592-0.288 3.504 0.624 0.888 0.888 1.152 2.232 0.696 3.384-0.072 0.336 0.072 0.696 0.336 0.792zM12.504 1.896c0.144 0.048 0.312 0.048 0.456-0.024 2.592-1.176 5.712-0.6 7.752 1.416 1.968 1.968 2.568 4.896 1.512 7.488-0.12 0.288 0.048 0.648 0.312 0.744 0.096 0.048 0.168 0.048 0.24 0.048 0.24 0 0.456-0.144 0.504-0.336 1.224-3.024 0.552-6.456-1.752-8.76-2.376-2.376-6-3.024-9.024-1.656-0.144 0.048-0.264 0.168-0.312 0.312s-0.048 0.312 0 0.432c0.048 0.168 0.168 0.264 0.312 0.336z"></path></svg>',
		'et_icon-whatsapp'        => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.952 11.688c0 6.432-5.256 11.64-11.712 11.64-2.064 0-3.984-0.528-5.664-1.44l-6.48 2.064 2.112-6.24c-1.056-1.752-1.68-3.816-1.68-6 0-6.432 5.256-11.64 11.712-11.64 6.456-0.024 11.712 5.184 11.712 11.616zM12.216 1.92c-5.424 0-9.864 4.368-9.864 9.768 0 2.136 0.696 4.128 1.872 5.736l-1.224 3.624 3.792-1.2c1.56 1.032 3.432 1.608 5.424 1.608 5.424 0.024 9.864-4.368 9.864-9.768s-4.44-9.768-9.864-9.768zM18.144 14.376c-0.072-0.12-0.264-0.192-0.552-0.336s-1.704-0.84-1.968-0.936c-0.264-0.096-0.456-0.144-0.648 0.144s-0.744 0.936-0.912 1.128c-0.168 0.192-0.336 0.216-0.624 0.072s-1.224-0.432-2.304-1.416c-0.864-0.744-1.44-1.68-1.608-1.968s-0.024-0.432 0.12-0.576c0.12-0.12 0.288-0.336 0.432-0.504s0.192-0.288 0.288-0.48c0.096-0.192 0.048-0.36-0.024-0.504s-0.648-1.536-0.888-2.112c-0.24-0.576-0.48-0.48-0.648-0.48s-0.36-0.024-0.552-0.024c-0.192 0-0.504 0.072-0.768 0.36s-1.008 0.984-1.008 2.376c0 1.392 1.032 2.76 1.176 2.952s1.992 3.168 4.92 4.296c2.928 1.152 2.928 0.768 3.456 0.72s1.704-0.696 1.944-1.344c0.24-0.672 0.24-1.248 0.168-1.368z"></path></svg>',
		'et_icon-close'           => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 16 16"><path d="M9.024 8l6.752-6.736c0.144-0.144 0.208-0.32 0.208-0.528 0-0.192-0.080-0.368-0.208-0.512l-0.016-0.016c-0.080-0.080-0.272-0.192-0.496-0.192-0.208 0-0.4 0.080-0.512 0.208l-6.752 6.752-6.736-6.752c-0.272-0.272-0.736-0.288-1.008 0-0.144 0.128-0.224 0.32-0.224 0.512 0 0.208 0.080 0.384 0.208 0.528l6.736 6.736-6.752 6.736c-0.144 0.144-0.208 0.32-0.208 0.528 0 0.192 0.064 0.368 0.208 0.512 0.128 0.128 0.32 0.208 0.512 0.208s0.368-0.080 0.512-0.208l6.752-6.752 6.736 6.736c0.128 0.128 0.32 0.208 0.512 0.208s0.368-0.080 0.512-0.208c0.128-0.128 0.208-0.32 0.208-0.512s-0.080-0.368-0.208-0.512l-6.736-6.736z"></path></svg>',
		'et_icon-exclamation'     => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12.24 4.92h-0.48c-0.336 0-0.6 0.168-0.6 0.384v8.76c0 0.216 0.264 0.384 0.6 0.384h0.48c0.336 0 0.6-0.168 0.6-0.408v-8.736c0-0.216-0.264-0.384-0.6-0.384zM12.24 16.464h-0.48c-0.336 0-0.6 0.264-0.6 0.6v1.44c0 0.336 0.264 0.6 0.6 0.6h0.48c0.336 0 0.6-0.264 0.6-0.6v-1.44c0-0.336-0.264-0.6-0.6-0.6zM12 0.024c-6.624 0-11.976 5.352-11.976 11.976s5.352 11.976 11.976 11.976 11.976-5.352 11.976-11.976-5.352-11.976-11.976-11.976zM12 22.704c-5.928 0-10.704-4.8-10.704-10.704s4.776-10.704 10.704-10.704 10.704 4.8 10.704 10.704c0 5.928-4.776 10.704-10.704 10.704z"></path></svg>',
		'et_icon-gift'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M22.848 4.944h-5.904c0.888-0.384 1.656-0.84 2.112-1.44l0.024-0.024c0.312-0.384 0.48-0.864 0.48-1.344 0-1.176-0.96-2.136-2.136-2.136-0.144 0-0.264 0.024-0.384 0.048-1.632 0.288-3.888 1.944-5.040 3.84-1.152-1.896-3.384-3.576-5.016-3.84-0.144-0.024-0.264-0.048-0.408-0.048-1.176 0-2.136 0.96-2.136 2.136 0 0.48 0.168 0.96 0.48 1.368 0.456 0.6 1.248 1.080 2.136 1.44h-5.904c-0.36 0-0.648 0.288-0.648 0.648v3.96c0 0.36 0.288 0.648 0.648 0.648h0.336v13.176c0 0.36 0.288 0.648 0.648 0.648h19.752c0.36 0 0.648-0.288 0.648-0.648v-13.2h0.336c0.36 0 0.648-0.288 0.648-0.648v-3.936c-0.024-0.36-0.312-0.648-0.672-0.648zM6.576 1.296c0.048 0 0.12 0 0.168 0.024 1.416 0.24 3.408 1.848 4.272 3.432-2.040-0.408-4.368-1.152-5.064-2.064-0.024-0.024-0.024-0.024-0.024-0.048-0.12-0.144-0.168-0.312-0.168-0.504-0.024-0.456 0.36-0.84 0.816-0.84zM12.984 4.752c0.864-1.584 2.856-3.192 4.272-3.432 0.048 0 0.12-0.024 0.168-0.024 0.456 0 0.84 0.384 0.84 0.84 0 0.192-0.048 0.36-0.168 0.504-0.024 0.024-0.024 0.024-0.024 0.048-0.72 0.912-3.048 1.656-5.088 2.064zM22.2 8.88h-9.552v-2.64h9.552v2.64zM2.784 10.176h8.568v12.528h-8.568v-12.528zM1.8 8.88v-2.64h9.552v2.64h-9.552zM12.648 10.176h8.568v12.528h-8.568v-12.528z"></path></svg>',
		'et_icon-heart'           => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.88 7.56c-0.264-3.432-3.168-6.192-6.624-6.288-1.944-0.072-3.912 0.768-5.256 2.208-1.368-1.464-3.264-2.28-5.256-2.208-3.456 0.096-6.36 2.856-6.624 6.288-0.024 0.288-0.024 0.6-0.024 0.888 0.048 1.224 0.576 2.448 1.464 3.432l9.408 10.416c0.264 0.288 0.648 0.456 1.032 0.456s0.768-0.168 1.056-0.456l9.384-10.416c0.888-0.984 1.392-2.184 1.464-3.432 0-0.288 0-0.6-0.024-0.888zM11.904 21.408l-9.384-10.416c-0.672-0.744-1.080-1.68-1.128-2.616 0-0.24 0-0.48 0.024-0.72 0.216-2.76 2.568-5.016 5.352-5.088 0.048 0 0.12 0 0.168 0 1.776 0 3.48 0.864 4.512 2.328 0.12 0.168 0.312 0.264 0.528 0.264s0.408-0.096 0.528-0.264c1.080-1.512 2.832-2.376 4.704-2.328 2.784 0.096 5.136 2.328 5.376 5.088 0.024 0.24 0.024 0.48 0.024 0.72v0c-0.048 0.936-0.432 1.872-1.128 2.616l-9.384 10.416c-0.048 0.048-0.168 0.024-0.192 0z"></path></svg>',
		'et_icon-message'         => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.928 5.424c-0.024-0.648-0.552-1.152-1.176-1.152h-21.504c-0.648 0-1.176 0.528-1.176 1.176v13.128c0 0.648 0.528 1.176 1.176 1.176h21.504c0.648 0 1.176-0.528 1.176-1.176v-13.152zM22.512 5.4l-10.512 6.576-10.512-6.576h21.024zM1.248 16.992v-10.416l7.344 4.584-7.344 5.832zM1.224 18.456l8.352-6.624 2.064 1.32c0.192 0.12 0.432 0.12 0.624 0l2.064-1.32 8.4 6.648 0.024 0.096c0 0 0 0.024-0.024 0.024h-21.48c-0.024 0-0.024 0-0.024-0.024v-0.12zM22.752 6.648v10.344l-7.344-5.808 7.344-4.536z"></path></svg>',
		'et_icon-internet'        => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0.36v0c-6.432 0-11.64 5.208-11.64 11.64s5.208 11.64 11.64 11.64 11.64-5.208 11.64-11.64c-0.024-6.408-5.232-11.616-11.64-11.64zM12.552 16.872v-4.272h4.92c-0.048 1.632-0.288 3.24-0.768 4.776-1.296-0.288-2.688-0.456-4.152-0.504zM15.456 21.912c0.864-0.96 1.56-2.064 2.016-3.264 0.744 0.192 1.44 0.408 2.064 0.672-1.152 1.176-2.544 2.064-4.080 2.592zM12.552 22.44v-4.44c1.32 0.024 2.592 0.168 3.768 0.408-0.912 2.28-2.28 3.744-3.768 4.032zM17.472 11.472h-4.92v-4.32c1.368-0.024 2.76-0.192 4.152-0.456 0.48 1.512 0.744 3.12 0.768 4.776zM17.448 5.352c-0.432-1.2-1.104-2.328-1.968-3.288 1.536 0.552 2.928 1.44 4.056 2.616-0.696 0.264-1.368 0.48-2.088 0.672zM12.552 6v-4.44c1.488 0.288 2.856 1.752 3.768 4.056-1.2 0.216-2.472 0.36-3.768 0.384zM22.464 12.6c-0.096 2.16-0.864 4.176-2.16 5.832-0.816-0.36-1.656-0.672-2.472-0.888 0.48-1.608 0.744-3.288 0.792-4.944h3.84zM22.464 11.424h-3.864c-0.048-1.68-0.312-3.36-0.792-4.992 0.84-0.192 1.656-0.48 2.472-0.84 1.32 1.68 2.064 3.696 2.184 5.832zM6.528 18.6c0.432 1.224 1.128 2.352 1.992 3.312-1.536-0.528-2.952-1.44-4.104-2.64 0.696-0.264 1.392-0.48 2.112-0.672zM6.528 12.528h4.92v4.296c-1.368 0.024-2.76 0.192-4.152 0.456-0.48-1.512-0.744-3.12-0.768-4.752zM11.424 18v4.464c-1.488-0.288-2.856-1.752-3.768-4.056 1.224-0.24 2.496-0.384 3.768-0.408zM6.192 17.568c-0.816 0.192-1.632 0.456-2.472 0.816-1.296-1.68-2.040-3.672-2.16-5.832l3.864 0.024c0 1.656 0.264 3.336 0.768 4.992zM1.536 11.4c0.096-2.16 0.864-4.176 2.16-5.832 0.816 0.36 1.656 0.672 2.472 0.888-0.48 1.608-0.744 3.288-0.792 4.944h-3.84zM11.424 7.128v4.272h-4.896c0.048-1.632 0.288-3.24 0.768-4.776 1.296 0.288 2.688 0.456 4.128 0.504zM4.464 4.68c1.152-1.176 2.544-2.064 4.056-2.592-0.864 0.936-1.536 2.040-1.992 3.264-0.744-0.192-1.416-0.408-2.064-0.672zM11.424 1.56v4.44c-1.32-0.024-2.592-0.168-3.768-0.408 0.936-2.28 2.304-3.744 3.768-4.032z"></path></svg>',
		'et_icon-account'         => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M16.848 12.168c1.56-1.32 2.448-3.216 2.448-5.232 0-3.768-3.072-6.84-6.84-6.84s-6.864 3.072-6.864 6.84c0 2.016 0.888 3.912 2.448 5.232-4.080 1.752-6.792 6.216-6.792 11.136 0 0.36 0.288 0.672 0.672 0.672h21.072c0.36 0 0.672-0.288 0.672-0.672-0.024-4.92-2.76-9.384-6.816-11.136zM12.432 1.44c3.048 0 5.52 2.472 5.52 5.52 0 1.968-1.056 3.792-2.76 4.776l-0.048 0.024c0 0 0 0-0.024 0-0.048 0.024-0.096 0.048-0.144 0.096h-0.024c-0.792 0.408-1.632 0.624-2.544 0.624-3.048 0-5.52-2.472-5.52-5.52s2.52-5.52 5.544-5.52zM9.408 13.056c0.96 0.48 1.968 0.72 3.024 0.72s2.064-0.24 3.024-0.72c3.768 1.176 6.576 5.088 6.816 9.552h-19.68c0.264-4.44 3.048-8.376 6.816-9.552z"></path></svg>',
		'et_icon-sent'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M22.488 6.744v0c-0.048-0.072-0.072-0.12-0.12-0.168l-3.312-5.76c-0.288-0.504-0.84-0.552-1.32-0.552h-11.472c-0.504 0-1.032 0.072-1.344 0.552l-3.384 5.904c-0.024 0.024-0.024 0.072-0.048 0.096 0 0.024-0.024 0.048-0.048 0.096-0.048 0.144-0.096 0.312-0.096 0.48v15.216c0 1.128 1.008 1.128 1.824 1.128h17.592c0.816 0 1.824 0 1.824-1.128v-15.36c0.048-0.192 0-0.36-0.096-0.504zM2.784 6.768l3.264-5.568 5.4-0.048v5.568l-8.664 0.048zM12.552 6.744l0.024-5.568h5.544l3.096 5.568h-8.664zM21.552 22.632h-19.104c-0.048 0-0.048-0.024-0.048-0.048v-14.808h19.2v14.808c0 0.048-0.024 0.048-0.048 0.048zM16.68 11.808c-0.168-0.024-0.336 0.048-0.456 0.144l-4.632 4.512-2.424-2.496c-0.12-0.12-0.264-0.168-0.432-0.168s-0.336 0.072-0.408 0.192c-0.12 0.144-0.168 0.312-0.144 0.48 0.024 0.144 0.072 0.264 0.168 0.312l2.832 2.928c0.12 0.12 0.264 0.168 0.408 0.168s0.288-0.048 0.408-0.168l5.040-4.92c0.12-0.12 0.168-0.264 0.168-0.432 0-0.144-0.072-0.288-0.168-0.36-0.072-0.12-0.216-0.192-0.36-0.192z"></path></svg>',
		'et_icon-home'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.779 9.632l-1.915-1.75v-5.347c0-0.331-0.346-0.602-0.677-0.602l-4.349-0.046c-0.331 0-0.602 0.269-0.602 0.602v1.039l-3.857-3.122c-0.221-0.18-0.54-0.18-0.758 0l-11.398 9.226c-0.257 0.209-0.298 0.59-0.091 0.85 0.115 0.142 0.286 0.223 0.473 0.223 0.139 0 0.274-0.048 0.377-0.134l1.188-0.96v13.517c0 0.331 0.271 0.602 0.605 0.602h6.47c0.357 0 0.646-0.289 0.646-0.646v-9.122h4.219v9.122c0 0.357 0.289 0.646 0.646 0.646h6.47c0.334 0 0.605-0.271 0.605-0.602v-13.517l1.188 0.96c0.125 0.101 0.283 0.149 0.444 0.132 0.149-0.017 0.283-0.086 0.384-0.199l0.022-0.022c0.206-0.259 0.166-0.638-0.089-0.85zM15.317 22.522v-9.768h-6.634v9.768h-5.306v-13.886l8.623-6.969 5.443 4.399v-2.969h3.18v6.586l0.007 12.84h-5.314z"></path></svg>',
		'et_icon-shop'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M22.673 20.61h-0.145v-9.837c0.924-0.647 1.472-1.691 1.472-2.821 0-0.103-0.027-0.205-0.078-0.293l-2.732-4.782c-0.236-0.412-0.677-0.669-1.153-0.669h-16.075c-0.475 0-0.917 0.256-1.152 0.669l-2.732 4.782c-0.051 0.089-0.078 0.191-0.078 0.293 0 1.13 0.548 2.174 1.472 2.821v9.837h-0.145c-0.326 0-0.591 0.265-0.591 0.591s0.265 0.591 0.591 0.591h21.346c0.326 0 0.591-0.265 0.591-0.591s-0.265-0.591-0.591-0.591zM19.506 12.959v7.651h-3.234v-7.651h3.234zM1.61 7.361l2.227-3.897c0.026-0.045 0.074-0.073 0.126-0.073h16.075c0.052 0 0.1 0.028 0.126 0.073l2.227 3.897h-20.78zM18.375 8.543h4.365c-0.263 0.97-1.156 1.67-2.182 1.67s-1.919-0.7-2.182-1.67zM20.097 11.777h-4.416c-0.326 0-0.591 0.265-0.591 0.591v8.242h-12.435v-9.307c0.258 0.061 0.522 0.092 0.789 0.092 1.158 0 2.216-0.571 2.852-1.515 0.637 0.944 1.695 1.515 2.852 1.515s2.216-0.571 2.852-1.515c0.637 0.944 1.695 1.515 2.852 1.515s2.215-0.571 2.852-1.515c0.637 0.944 1.695 1.515 2.852 1.515 0.267 0 0.531-0.031 0.789-0.092v9.307h-0.658v-8.242c0-0.326-0.265-0.591-0.591-0.591zM9.148 10.213c-1.026 0-1.919-0.701-2.182-1.67h4.364c-0.263 0.969-1.156 1.67-2.182 1.67zM14.852 10.213c-1.027 0-1.919-0.7-2.182-1.67h4.364c-0.263 0.97-1.155 1.67-2.182 1.67zM3.443 10.213c-1.027 0-1.919-0.7-2.183-1.67h4.365c-0.263 0.969-1.156 1.67-2.182 1.67z"></path><path d="M11.84 12.626h-7.587c-0.313 0-0.568 0.255-0.568 0.568v5.339c0 0.313 0.255 0.568 0.568 0.568h7.587c0.313 0 0.569-0.255 0.569-0.568v-5.339c0-0.313-0.255-0.568-0.569-0.568zM11.272 13.763v4.202h-6.45v-4.202h6.45z"></path></svg>',
		'et_icon-shopping-bag'    => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M20.232 5.352c-0.024-0.528-0.456-0.912-0.936-0.912h-2.736c-0.12-2.448-2.112-4.392-4.56-4.392s-4.464 1.944-4.56 4.392h-2.712c-0.528 0-0.936 0.432-0.936 0.936l-0.648 16.464c-0.024 0.552 0.168 1.104 0.552 1.512s0.888 0.624 1.464 0.624h13.68c0.552 0 1.056-0.216 1.464-0.624 0.36-0.408 0.552-0.936 0.552-1.488l-0.624-16.512zM12 1.224c1.8 0 3.288 1.416 3.408 3.216l-6.816-0.024c0.12-1.776 1.608-3.192 3.408-3.192zM7.44 5.616v1.968c0 0.336 0.264 0.6 0.6 0.6s0.6-0.264 0.6-0.6v-1.968h6.792v1.968c0 0.336 0.264 0.6 0.6 0.6s0.6-0.264 0.6-0.6v-1.968h2.472l0.624 16.224c-0.024 0.24-0.12 0.48-0.288 0.648s-0.384 0.264-0.6 0.264h-13.68c-0.24 0-0.456-0.096-0.624-0.264s-0.24-0.384-0.216-0.624l0.624-16.248h2.496z"></path></svg>',
		'et_icon-shopping-cart'   => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.76 4.248c-0.096-0.096-0.24-0.24-0.504-0.24h-18.48l-0.48-2.4c-0.024-0.288-0.384-0.528-0.624-0.528h-2.952c-0.384 0-0.624 0.264-0.624 0.624s0.264 0.648 0.624 0.648h2.424l2.328 11.832c0.312 1.608 1.848 2.856 3.48 2.856h11.28c0.384 0 0.624-0.264 0.624-0.624s-0.264-0.624-0.624-0.624h-11.16c-0.696 0-1.344-0.312-1.704-0.816l14.064-1.92c0.264 0 0.528-0.24 0.528-0.528l1.968-7.824v-0.024c-0.024-0.048-0.024-0.288-0.168-0.432zM22.392 5.184l-1.608 6.696-14.064 1.824-1.704-8.52h17.376zM8.568 17.736c-1.464 0-2.592 1.128-2.592 2.592s1.128 2.592 2.592 2.592c1.464 0 2.592-1.128 2.592-2.592s-1.128-2.592-2.592-2.592zM9.888 20.328c0 0.696-0.624 1.32-1.32 1.32s-1.32-0.624-1.32-1.32 0.624-1.32 1.32-1.32 1.32 0.624 1.32 1.32zM18.36 17.736c-1.464 0-2.592 1.128-2.592 2.592s1.128 2.592 2.592 2.592c1.464 0 2.592-1.128 2.592-2.592s-1.128-2.592-2.592-2.592zM19.704 20.328c0 0.696-0.624 1.32-1.32 1.32s-1.344-0.6-1.344-1.32 0.624-1.32 1.32-1.32 1.344 0.624 1.344 1.32z"></path></svg>',
		'et_icon-shopping-cart-2' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M0.096 4.656v0.024l1.968 7.824c0 0.264 0.264 0.528 0.528 0.528l14.064 1.92c-0.384 0.504-1.032 0.816-1.704 0.816h-11.184c-0.384 0-0.624 0.264-0.624 0.624s0.264 0.624 0.624 0.624h11.28c1.656 0 3.168-1.248 3.48-2.856l2.328-11.832h2.424c0.384 0 0.624-0.264 0.624-0.624s-0.264-0.624-0.624-0.624h-2.952c-0.24 0-0.624 0.24-0.624 0.528l-0.456 2.424h-18.528c-0.264 0-0.384 0.144-0.504 0.24-0.12 0.12-0.12 0.36-0.12 0.384zM18.984 5.184l-1.704 8.52-14.088-1.824-1.584-6.696h17.376zM12.84 20.328c0 1.464 1.128 2.592 2.592 2.592s2.592-1.128 2.592-2.592c0-1.464-1.128-2.592-2.592-2.592s-2.592 1.128-2.592 2.592zM15.432 19.008c0.696 0 1.32 0.624 1.32 1.32s-0.624 1.32-1.32 1.32-1.32-0.624-1.32-1.32 0.6-1.32 1.32-1.32zM3.024 20.328c0 1.464 1.128 2.592 2.592 2.592s2.592-1.128 2.592-2.592c0-1.464-1.128-2.592-2.592-2.592-1.44 0-2.592 1.128-2.592 2.592zM5.64 19.008c0.696 0 1.32 0.624 1.32 1.32s-0.624 1.32-1.32 1.32-1.32-0.624-1.32-1.32 0.6-1.32 1.32-1.32z"></path></svg>',
		'et_icon-burger'          => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M0.792 5.904h22.416c0.408 0 0.744-0.336 0.744-0.744s-0.336-0.744-0.744-0.744h-22.416c-0.408 0-0.744 0.336-0.744 0.744s0.336 0.744 0.744 0.744zM23.208 11.256h-22.416c-0.408 0-0.744 0.336-0.744 0.744s0.336 0.744 0.744 0.744h22.416c0.408 0 0.744-0.336 0.744-0.744s-0.336-0.744-0.744-0.744zM23.208 18.096h-22.416c-0.408 0-0.744 0.336-0.744 0.744s0.336 0.744 0.744 0.744h22.416c0.408 0 0.744-0.336 0.744-0.744s-0.336-0.744-0.744-0.744z"></path></svg>',
		'et_icon-star'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.856 9.216c-0.168-0.504-0.576-0.864-1.104-0.936l-6.6-0.96-2.928-6c-0.24-0.48-0.696-0.768-1.224-0.768s-0.984 0.288-1.224 0.768l-2.952 6-6.6 0.96c-0.504 0.072-0.936 0.432-1.104 0.936s-0.024 1.056 0.36 1.44l4.752 4.632-1.128 6.552c-0.072 0.408 0.048 0.816 0.312 1.128 0.408 0.48 1.104 0.624 1.656 0.336l5.928-3.144 5.928 3.12c0.192 0.096 0.408 0.144 0.624 0.144 0.408 0 0.768-0.168 1.032-0.48s0.384-0.72 0.312-1.128l-1.128-6.576 4.752-4.632c0.384-0.36 0.504-0.888 0.336-1.392zM5.4 22.056l1.2-6.912c0.048-0.216-0.024-0.432-0.192-0.576l-4.992-4.872c0 0-0.024-0.024-0.024-0.072 0-0.024 0.024-0.024 0.024-0.024l6.936-1.008c0.216-0.024 0.408-0.168 0.504-0.36l3.12-6.36c0-0.024 0.024-0.048 0.024-0.048s0.024 0.024 0.024 0.048l3.12 6.312c0.096 0.192 0.288 0.336 0.504 0.36l6.936 1.008c0 0 0.024 0 0.024 0.048 0.024 0.048 0 0.072-0.024 0.072l-4.992 4.896c-0.144 0.144-0.216 0.36-0.192 0.576l1.2 6.912c0 0.024 0 0.048-0.024 0.072v0l-6.264-3.288c-0.192-0.096-0.432-0.096-0.624 0l-6.264 3.264c-0.024-0.024-0.024-0.024-0.024-0.048z"></path></svg>',
		'et_icon-time'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0c-6.617 0-12 5.383-12 12s5.383 12 12 12 12-5.383 12-12-5.383-12-12-12zM12 22.519c-5.8 0-10.519-4.719-10.519-10.519s4.719-10.519 10.519-10.519 10.519 4.719 10.519 10.519-4.719 10.519-10.519 10.519z"></path><path d="M12 2.33c-0.408 0-0.74 0.332-0.74 0.74v8.578h-5.472c-0.408 0-0.74 0.332-0.74 0.741s0.332 0.74 0.74 0.74h6.212c0.408 0 0.74-0.332 0.74-0.74v-9.319c0-0.408-0.332-0.74-0.74-0.74z"></path></svg>',
		'et_icon-size'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M22.998 16.191l-10.384-5.486v-0.532c1.708-0.447 2.765-1.533 2.765-2.848 0-1.583-1.288-2.871-2.871-2.871-1.482 0-2.739 1.103-2.861 2.502-0.005 0.028-0.008 0.056-0.008 0.093 0 0.339 0.276 0.615 0.615 0.615 0.298 0 0.547-0.213 0.603-0.495l0.014-0.109c0.037-0.401 0.237-0.686 0.398-0.855 0.315-0.331 0.767-0.521 1.239-0.521 0.905 0 1.641 0.736 1.641 1.641 0 0.337-0.143 0.648-0.425 0.924-0.342 0.335-0.855 0.594-1.49 0.751-0.344 0.106-0.757 0.234-0.77 0.238l-0.080 0.028-0.001 1.437-10.382 5.485c-0.619 0.319-1.003 0.916-1.003 1.56 0 0.99 0.891 1.795 1.987 1.795h20.027c1.095 0 1.986-0.805 1.986-1.795 0-0.643-0.384-1.241-1.002-1.559zM22.771 17.75c0 0.301-0.354 0.565-0.757 0.565h-20.027c-0.403 0-0.757-0.264-0.757-0.565 0-0.183 0.126-0.359 0.323-0.462l10.446-5.517 10.434 5.511c0.211 0.11 0.337 0.285 0.337 0.468z"></path></svg>',
		'et_icon-more'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M3.36 8.688c-1.824 0-3.312 1.488-3.312 3.312s1.488 3.312 3.336 3.312c1.848 0 3.336-1.488 3.336-3.312 0-1.8-1.536-3.312-3.36-3.312zM5.544 12c0 1.2-0.984 2.184-2.184 2.184s-2.184-0.984-2.184-2.184 0.984-2.184 2.184-2.184 2.184 0.984 2.184 2.184zM20.64 8.688c-1.824 0-3.312 1.488-3.312 3.312 0 1.8 1.512 3.312 3.312 3.312s3.336-1.512 3.336-3.312c0-1.824-1.488-3.312-3.336-3.312zM22.824 12c0 1.2-0.984 2.184-2.184 2.184s-2.184-0.984-2.184-2.184 0.984-2.184 2.184-2.184c1.2 0 2.184 0.984 2.184 2.184zM12 8.688c-1.824 0-3.312 1.488-3.312 3.312 0 1.8 1.512 3.312 3.312 3.312s3.312-1.512 3.312-3.312c0-1.824-1.488-3.312-3.312-3.312zM12 14.184c-1.2 0-2.184-0.984-2.184-2.184s0.984-2.184 2.184-2.184 2.184 0.984 2.184 2.184-0.984 2.184-2.184 2.184z"></path></svg>'
	),
	'bold'  => array(
		'et_icon-delivery'        => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 16 16"><path d="M15.472 4.736h-1.952v-0.512c0-0.432-0.352-0.784-0.784-0.784h-7.696c-0.432 0-0.784 0.352-0.784 0.784v1.344h-1.84c-0.192 0-0.368 0.096-0.448 0.256l-0.976 1.712h-0.48c-0.288 0-0.512 0.224-0.512 0.512v2.88c0 0.288 0.24 0.512 0.512 0.512h0.56c0.224 0.672 0.848 1.136 1.552 1.136 0.112 0 0.208-0.016 0.304-0.032 0.608-0.112 1.072-0.528 1.264-1.088h0.56c0.032 0 0.048 0 0.080-0.016 0 0 0.016 0 0.016 0 0.064 0.016 0.128 0.016 0.176 0.016h3.168c0.256 0.784 1.056 1.264 1.872 1.088 0.608-0.112 1.072-0.528 1.264-1.088h1.408c0.432 0 0.784-0.352 0.784-0.784v-2.128h1.408c0.288 0 0.512-0.224 0.512-0.512s-0.208-0.512-0.496-0.512h-1.408v-0.368h0.032c0.288 0 0.512-0.224 0.512-0.512s-0.224-0.512-0.512-0.512h-0.032v-0.368h1.952c0.288 0 0.512-0.224 0.512-0.528-0.016-0.288-0.24-0.496-0.528-0.496zM9.088 6.656c0 0.288 0.224 0.512 0.512 0.512h2.88v0.368h-1.52c-0.144 0-0.288 0.064-0.368 0.16-0.096 0.096-0.144 0.224-0.144 0.352 0 0.288 0.224 0.512 0.512 0.512h1.504v1.856h-1.136c-0.112-0.352-0.336-0.64-0.64-0.848-0.368-0.256-0.816-0.336-1.232-0.256-0.608 0.112-1.072 0.528-1.264 1.088l-2.944-0.016 0.016-5.92 7.2 0.016v0.272h-0.976c-0.272 0-0.48 0.24-0.48 0.512 0 0.288 0.224 0.512 0.512 0.512h0.976v0.368h-2.896c-0.288-0.016-0.512 0.224-0.512 0.512zM9.776 10.304c0.352 0 0.624 0.288 0.624 0.624 0 0.352-0.288 0.624-0.624 0.624s-0.624-0.288-0.624-0.624c0-0.352 0.288-0.624 0.624-0.624zM2.64 10.304c0.352 0 0.624 0.288 0.624 0.624 0 0.352-0.288 0.624-0.624 0.624-0.352 0-0.624-0.272-0.624-0.624 0.016-0.352 0.288-0.624 0.624-0.624zM2.336 9.296c-0.608 0.112-1.072 0.528-1.264 1.088h-0.048v-1.84h3.216v1.856h-0.032c-0.112-0.352-0.336-0.64-0.64-0.848-0.384-0.256-0.816-0.352-1.232-0.256zM4.24 6.624v0.912h-2.048l0.528-0.912h1.52z"></path></svg>',
		'et_icon-coupon'          => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 16 16"><path d="M15.376 6.704c0.352 0 0.624-0.288 0.624-0.624v-2.56c0-0.352-0.288-0.624-0.624-0.624h-14.752c-0.336-0.016-0.624 0.272-0.624 0.624v2.56c0 0.352 0.288 0.624 0.624 0.624 0.72 0 1.296 0.576 1.296 1.296s-0.576 1.296-1.296 1.296c-0.336 0-0.624 0.272-0.624 0.624v2.56c0 0.352 0.288 0.64 0.624 0.64h14.736c0.352 0 0.624-0.288 0.624-0.624v-2.576c0-0.352-0.288-0.624-0.624-0.624-0.72 0-1.296-0.576-1.296-1.296s0.592-1.296 1.312-1.296zM12.816 8c0 1.168 0.8 2.192 1.92 2.48v1.376h-13.472v-1.376c1.12-0.288 1.92-1.312 1.92-2.48s-0.8-2.192-1.92-2.48v-1.376h13.472v1.376c-1.12 0.288-1.92 1.312-1.92 2.48zM4.48 6.736c-0.352 0-0.624 0.288-0.624 0.624v1.28c0 0.352 0.288 0.624 0.624 0.624 0.352 0 0.624-0.288 0.624-0.624v-1.28c0-0.352-0.288-0.624-0.624-0.624zM4.48 4.16c-0.352 0-0.64 0.288-0.64 0.64v1.28c0 0.352 0.288 0.624 0.624 0.624 0.352 0 0.624-0.288 0.624-0.624v-1.28c0.016-0.352-0.272-0.64-0.608-0.64zM4.48 9.296c-0.352 0-0.624 0.288-0.624 0.624v1.28c0 0.352 0.288 0.624 0.624 0.624 0.352 0 0.624-0.288 0.624-0.624v-1.28c0-0.352-0.288-0.624-0.624-0.624zM11.52 6.736c-0.352 0-0.624 0.288-0.624 0.624v1.28c0 0.352 0.288 0.624 0.624 0.624s0.64-0.272 0.64-0.624v-1.28c0-0.352-0.288-0.624-0.64-0.624zM11.52 4.16c-0.352 0-0.624 0.288-0.624 0.624v1.28c0 0.352 0.288 0.624 0.624 0.624s0.64-0.256 0.64-0.608v-1.28c0-0.352-0.288-0.64-0.64-0.64zM11.52 9.296c-0.352 0-0.624 0.288-0.624 0.624v1.28c0 0.352 0.288 0.624 0.624 0.624s0.64-0.272 0.64-0.624v-1.28c0-0.352-0.288-0.624-0.64-0.624z"></path></svg>',
		'et_icon-calendar'        => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 16 16"><path d="M15.456 1.616v0c-0.016-0.304-0.272-0.544-0.576-0.544h-1.472v-0.48c0-0.272-0.24-0.576-0.576-0.576h-1.792c-0.272 0-0.576 0.24-0.576 0.576v0.48h-5.008v-0.48c0-0.272-0.24-0.576-0.576-0.576h-1.76c-0.272 0-0.576 0.24-0.576 0.576v0.48h-1.424c-0.272 0-0.56 0.224-0.56 0.576v13.744c0 0.272 0.24 0.576 0.576 0.576h13.744c0.272 0 0.576-0.24 0.576-0.576v-13.776zM3.728 2.112v-0.96h0.672v0.96h-0.672zM11.6 2.112v-0.96h0.672v0.96h-0.672zM11.12 3.232h1.776c0.272 0 0.576-0.24 0.576-0.576v-0.48h0.912v1.696h-12.688v-1.68h0.944v0.464c-0.016 0.144 0.048 0.288 0.144 0.4 0.112 0.112 0.256 0.176 0.416 0.176h1.792c0.272 0 0.576-0.24 0.576-0.576v-0.48h4.992v0.48c-0.016 0.288 0.208 0.576 0.56 0.576zM1.696 14.848v-9.856h12.656v9.856h-12.656zM2.864 13.904h10.288v-8h-10.288v8zM12.032 11.6v1.2h-1.184v-1.184h1.184zM12.032 9.312v1.2h-1.184v-1.2h1.184zM12.032 7.008v1.2h-1.184v-1.2h1.184zM9.744 11.6v1.2h-1.168v-1.184h1.168zM9.744 9.312v1.2h-1.168v-1.2h1.168zM9.744 7.008v1.2h-1.168v-1.2h1.168zM7.44 11.6v1.2h-1.184v-1.184h1.184zM7.44 9.312v1.2h-1.184v-1.2h1.184zM7.44 7.008v1.2h-1.184v-1.2h1.184zM5.152 11.6v1.2h-1.184v-1.184h1.184zM5.168 9.312v1.2h-1.184v-1.2h1.184zM5.168 7.008v1.2h-1.184v-1.2h1.184z"></path></svg>',
		'et_icon-compare'         => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 16 16"><path d="M0.896 11.056c0.048 0.016 0.080 0.016 0.128 0.016 0.112 0 0.224-0.048 0.288-0.064l0.032-0.016 0.016-0.016c0.288-0.144 0.384-0.48 0.256-0.784-1.040-2.976 0.208-6.32 2.96-7.952 1.52-0.896 3.248-1.152 4.976-0.736 1.312 0.32 2.544 1.056 3.36 2-0.4 0-1.024 0-1.296 0.016-0.16 0-0.592 0-0.688 0.432-0.048 0.176-0.016 0.368 0.080 0.512 0.096 0.128 0.224 0.192 0.368 0.208 0.768 0.048 2.704 0.064 2.784 0.064 0.096 0 0.112 0 0.224-0.016 0.16-0.032 0.304-0.144 0.384-0.24l0.016-0.016c0.048-0.080 0.112-0.208 0.112-0.208l0.080-0.352c0.144-0.64 0.384-1.616 0.448-2.16 0.064-0.464-0.192-0.624-0.384-0.688-0.224-0.080-0.544-0.048-0.736 0.432-0.096 0.256-0.224 0.864-0.304 1.264-1.040-1.2-2.528-2.112-4.128-2.496l-0.064-0.016c-2.016-0.496-4.128-0.16-5.968 0.944-3.696 2.256-4.496 6.496-3.376 9.536 0.064 0.16 0.24 0.304 0.432 0.336zM15.504 5.312c-0.064-0.16-0.24-0.304-0.432-0.336-0.16-0.048-0.32 0.016-0.416 0.048l-0.032 0.016-0.016 0.016c-0.288 0.144-0.384 0.48-0.256 0.784 1.040 2.976-0.208 6.32-2.96 7.952-1.52 0.896-3.248 1.152-4.976 0.736-1.312-0.32-2.544-1.056-3.36-2 0.4 0 1.024 0 1.296-0.016 0.16 0 0.592 0 0.688-0.432 0.048-0.176 0.016-0.368-0.080-0.512-0.096-0.128-0.224-0.192-0.368-0.208-0.768-0.048-2.704-0.064-2.784-0.064-0.096 0-0.112 0-0.224 0.016-0.16 0.032-0.304 0.144-0.384 0.24l-0.016 0.016c-0.048 0.080-0.128 0.224-0.128 0.224l-0.016 0.048c-0.144 0.592-0.432 1.84-0.528 2.464-0.064 0.464 0.192 0.624 0.4 0.688 0.224 0.064 0.544 0.032 0.736-0.464 0.096-0.256 0.224-0.864 0.304-1.264 1.040 1.2 2.528 2.112 4.144 2.512l0.064 0.016c0.608 0.144 1.216 0.224 1.824 0.224 1.44 0 2.864-0.4 4.144-1.168 3.696-2.24 4.496-6.496 3.376-9.536z"></path></svg>',
		'et_icon-checked'         => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 16 16"><path d="M8 0.048c-4.384 0-7.952 3.568-7.952 7.952s3.568 7.952 7.952 7.952 7.952-3.568 7.952-7.952-3.568-7.952-7.952-7.952zM8 14.656c-3.68 0-6.656-2.976-6.656-6.656s2.976-6.656 6.656-6.656c3.68 0 6.656 2.976 6.656 6.656s-2.976 6.656-6.656 6.656zM12.080 5.088c-0.176-0.016-0.368 0.048-0.496 0.176l-4.72 4.576-2.448-2.512c-0.128-0.128-0.304-0.192-0.496-0.192s-0.368 0.080-0.464 0.24c-0.112 0.144-0.176 0.336-0.16 0.512 0.016 0.144 0.080 0.288 0.192 0.368l2.896 2.992c0.128 0.128 0.288 0.192 0.464 0.192 0.16 0 0.32-0.064 0.448-0.192l5.168-5.040c0.128-0.128 0.192-0.304 0.192-0.496 0-0.16-0.064-0.32-0.176-0.416-0.096-0.128-0.24-0.192-0.4-0.208z"></path></svg>',
		'et_icon-chat'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 16 16"><path d="M14.032 0.32h-12.080c-1.072 0-1.952 0.864-1.952 1.936v8.272c0 1.072 0.88 1.952 1.952 1.952h1.488l1.392 2.816c0.096 0.24 0.352 0.384 0.608 0.384 0.24 0 0.464-0.128 0.592-0.352l1.408-2.832h6.592c1.072 0 1.952-0.88 1.952-1.952v-8.288c0-1.072-0.88-1.936-1.952-1.936zM14.672 2.256v8.272c0 0.336-0.272 0.608-0.608 0.608h-7.024c-0.272 0-0.496 0.144-0.592 0.368l-1.008 1.984-0.976-1.968c-0.096-0.24-0.352-0.384-0.608-0.384h-1.904c-0.32 0-0.592-0.272-0.592-0.592v-8.288c0-0.336 0.272-0.608 0.608-0.608h12.096c0.336 0 0.608 0.272 0.608 0.608z"></path></svg>',
		'et_icon-phone'           => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M21.984 16.080v0c-3.624-2.904-5.112-1.368-6.408 0l-0.216 0.216c-0.12 0.024-0.552-0.072-1.272-0.528-0.84-0.552-1.896-1.464-3.12-2.688-3.24-3.24-3.24-4.272-3.216-4.416l0.216-0.216c1.416-1.392 2.88-2.832-0.048-6.408-0.96-1.2-1.944-1.8-2.976-1.848-1.536-0.096-2.736 1.176-3.552 2.040-0.096 0.12-0.24 0.264-0.36 0.384-1.104 1.080-1.152 3.336-0.144 6.024 1.056 2.808 3.144 5.856 5.88 8.592 2.712 2.712 5.76 4.8 8.568 5.88 1.296 0.504 2.472 0.744 3.528 0.744 1.080 0 1.944-0.288 2.496-0.816 0.144-0.12 0.312-0.264 0.456-0.432 0.888-0.84 2.088-1.968 2.016-3.504 0-1.032-0.624-2.016-1.848-3.024zM6.672 7.128l-0.24 0.24c-1.272 1.296-0.264 3.432 3.288 6.96 1.32 1.32 2.448 2.28 3.432 2.928 1.944 1.272 3 0.864 3.528 0.312l0.264-0.264c1.2-1.2 1.656-1.656 3.96 0.192 0.768 0.624 1.176 1.176 1.2 1.632 0.024 0.72-0.816 1.512-1.464 2.088-0.144 0.12-0.288 0.24-0.384 0.36-0.024 0.024-0.072 0.072-0.096 0.096-0.456 0.456-2.040 0.48-4.152-0.312-2.568-0.96-5.376-2.88-7.944-5.448-2.52-2.424-4.464-5.232-5.496-7.896-0.768-2.136-0.72-3.696-0.288-4.104 0.048-0.048 0.072-0.096 0.12-0.144 0.024-0.024 0.048-0.072 0.096-0.096 0.072-0.072 0.144-0.144 0.24-0.264 0.648-0.696 1.392-1.464 2.064-1.464h0.048c0.48 0.024 1.032 0.408 1.656 1.176 1.848 2.352 1.368 2.832 0.168 4.008zM18.12 9.336c-0.12 0.48 0.12 0.984 0.528 1.152 0.168 0.072 0.288 0.072 0.36 0.072 0.36 0 0.672-0.216 0.84-0.576 0.672-1.656 0.288-3.576-1.008-4.872s-3.312-1.68-5.016-0.936c-0.24 0.096-0.432 0.288-0.504 0.528-0.072 0.216-0.072 0.456 0 0.648 0.072 0.24 0.288 0.432 0.528 0.528 0.24 0.072 0.504 0.072 0.696-0.048 1.008-0.456 2.232-0.24 3 0.528s0.984 1.896 0.6 2.904l-0.024 0.072zM12.336 2.52l0.048 0.024c0.24 0.072 0.504 0.072 0.696-0.048 2.376-1.080 5.232-0.552 7.104 1.296 1.8 1.8 2.352 4.512 1.392 6.864-0.096 0.216-0.096 0.48 0.024 0.696 0.096 0.216 0.264 0.384 0.48 0.48 0.168 0.072 0.288 0.072 0.36 0.072 0.384 0 0.72-0.24 0.816-0.552 1.224-3.048 0.528-6.528-1.776-8.832-2.376-2.376-6.048-3.072-9.12-1.68-0.24 0.096-0.432 0.288-0.504 0.504s-0.072 0.456 0 0.648c0.096 0.36 0.384 0.504 0.48 0.528z"></path></svg>',
		'et_icon-whatsapp'        => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.952 11.688c0 6.432-5.256 11.64-11.712 11.64-2.064 0-3.984-0.528-5.664-1.44l-6.48 2.064 2.112-6.24c-1.056-1.752-1.68-3.816-1.68-6 0-6.432 5.256-11.64 11.712-11.64 6.456-0.024 11.712 5.184 11.712 11.616zM12.216 1.92c-5.424 0-9.864 4.368-9.864 9.768 0 2.136 0.696 4.128 1.872 5.736l-1.224 3.624 3.792-1.2c1.56 1.032 3.432 1.608 5.424 1.608 5.424 0.024 9.864-4.368 9.864-9.768s-4.44-9.768-9.864-9.768zM18.144 14.376c-0.072-0.12-0.264-0.192-0.552-0.336s-1.704-0.84-1.968-0.936c-0.264-0.096-0.456-0.144-0.648 0.144s-0.744 0.936-0.912 1.128c-0.168 0.192-0.336 0.216-0.624 0.072s-1.224-0.432-2.304-1.416c-0.864-0.744-1.44-1.68-1.608-1.968s-0.024-0.432 0.12-0.576c0.12-0.12 0.288-0.336 0.432-0.504s0.192-0.288 0.288-0.48c0.096-0.192 0.048-0.36-0.024-0.504s-0.648-1.536-0.888-2.112c-0.24-0.576-0.48-0.48-0.648-0.48s-0.36-0.024-0.552-0.024c-0.192 0-0.504 0.072-0.768 0.36s-1.008 0.984-1.008 2.376c0 1.392 1.032 2.76 1.176 2.952s1.992 3.168 4.92 4.296c2.928 1.152 2.928 0.768 3.456 0.72s1.704-0.696 1.944-1.344c0.24-0.672 0.24-1.248 0.168-1.368z"></path></svg>',
		'et_icon-close'           => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 16 16"><path d="M8.704 8l7.152-7.136c0.096-0.096 0.144-0.224 0.144-0.368 0-0.128-0.048-0.256-0.144-0.352-0.096-0.080-0.224-0.144-0.352-0.144 0 0 0 0 0 0-0.128 0-0.272 0.048-0.352 0.144l-7.152 7.152-7.136-7.152c-0.192-0.192-0.512-0.192-0.704 0-0.112 0.096-0.16 0.224-0.16 0.352 0 0.144 0.048 0.272 0.144 0.368l7.152 7.136-7.152 7.136c-0.096 0.096-0.144 0.224-0.144 0.368s0.048 0.256 0.144 0.352c0.192 0.192 0.512 0.192 0.704 0l7.152-7.152 7.136 7.136c0.096 0.096 0.224 0.144 0.352 0.144s0.256-0.048 0.352-0.144c0.096-0.096 0.144-0.224 0.144-0.352s-0.048-0.256-0.144-0.352l-7.136-7.136z"></path></svg>',
		'et_icon-exclamation'     => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0.024c-6.6 0-11.976 5.376-11.976 11.976s5.376 11.976 11.976 11.976 11.976-5.376 11.976-11.976-5.376-11.976-11.976-11.976zM12 22.056c-5.544 0-10.056-4.512-10.056-10.056s4.512-10.056 10.056-10.056 10.056 4.512 10.056 10.056-4.512 10.056-10.056 10.056zM12.24 4.656h-0.48c-0.48 0-0.84 0.264-0.84 0.624v8.808c0 0.336 0.36 0.624 0.84 0.624h0.48c0.48 0 0.84-0.264 0.84-0.624v-8.808c0-0.336-0.36-0.624-0.84-0.624zM12.24 16.248h-0.48c-0.456 0-0.84 0.384-0.84 0.84v1.44c0 0.456 0.384 0.84 0.84 0.84h0.48c0.456 0 0.84-0.384 0.84-0.84v-1.44c0-0.456-0.384-0.84-0.84-0.84z"></path></svg>',
		'et_icon-gift'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.52 5.712c-0.024-0.48-0.432-0.864-0.888-0.864h-4.776c0.552-0.312 0.96-0.648 1.248-1.032l0.024-0.024c0.336-0.408 0.528-0.936 0.528-1.464 0-1.272-1.056-2.328-2.328-2.328-0.168 0-0.312 0.024-0.408 0.048-1.656 0.312-3.744 1.824-4.92 3.576-1.2-1.776-3.264-3.312-4.872-3.552h-0.048c-0.12-0.048-0.24-0.072-0.384-0.072-1.272 0-2.328 1.032-2.328 2.328 0 0.528 0.192 1.056 0.528 1.488 0.288 0.384 0.696 0.72 1.248 1.032h-4.776c-0.48 0-0.864 0.384-0.864 0.864v3.888c0 0.48 0.384 0.864 0.864 0.864h0.096v12.672c0 0.48 0.384 0.864 0.864 0.864h19.344c0.48 0 0.864-0.384 0.864-0.864v-12.696h0.096c0.48 0 0.864-0.384 0.864-0.864l0.024-3.864zM20.784 10.44v11.808h-7.92v-11.808h7.92zM13.44 4.56c0.912-1.344 2.544-2.568 3.72-2.784 0.024 0 0.072 0 0.096-0.024 0.024 0 0.024 0 0.048 0 0.312 0 0.576 0.264 0.576 0.576 0 0.144-0.024 0.264-0.096 0.336-0.024 0.024-0.048 0.072-0.072 0.12-0.624 0.744-2.52 1.392-4.272 1.776zM21.744 6.6v2.112h-8.88v-2.112h8.88zM11.136 10.44v11.808h-7.92v-11.808h7.92zM6.24 2.688c-0.072-0.096-0.12-0.192-0.12-0.36 0-0.144 0.048-0.288 0.144-0.384 0.12-0.12 0.264-0.192 0.408-0.192 0.024 0 0.048 0 0.048 0l0.072 0.024c1.176 0.192 2.832 1.44 3.744 2.784-1.752-0.384-3.648-1.032-4.272-1.8v-0.024l-0.024-0.048zM11.136 6.6v2.112h-8.88v-2.112h8.88z"></path></svg>',
		'et_icon-heart'           => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.928 7.656c-0.264-3.528-3.264-6.36-6.792-6.456-1.872-0.072-3.768 0.672-5.136 1.992-1.392-1.344-3.24-2.064-5.136-1.992-3.528 0.096-6.528 2.928-6.792 6.456-0.024 0.288-0.024 0.624-0.024 0.912 0.048 1.272 0.6 2.544 1.512 3.576l9.168 10.152c0.312 0.36 0.792 0.552 1.272 0.552 0.456 0 0.936-0.192 1.296-0.552l9.144-10.152c0.912-1.008 1.44-2.256 1.512-3.576 0-0.312 0-0.624-0.024-0.912zM21.96 8.448c-0.048 0.864-0.408 1.68-1.008 2.328l-8.952 9.96-8.976-9.96c-0.6-0.672-0.96-1.488-1.008-2.304 0-0.24 0-0.456 0.024-0.672 0.192-2.52 2.328-4.56 4.848-4.632h0.168c1.632 0 3.168 0.792 4.104 2.112 0.192 0.264 0.48 0.408 0.816 0.408s0.624-0.144 0.816-0.408c0.984-1.368 2.592-2.16 4.272-2.112 2.52 0.096 4.68 2.112 4.896 4.632 0 0.216 0 0.432 0 0.648z"></path></svg>',
		'et_icon-message'         => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.928 5.616c-0.024-0.816-0.696-1.464-1.488-1.464h-20.88c-0.816 0-1.488 0.672-1.488 1.488v12.744c0 0.816 0.672 1.488 1.488 1.488h20.856c0.816 0 1.488-0.672 1.488-1.488l0.024-12.768zM20.976 5.952l-8.976 5.616-8.976-5.616h17.952zM1.92 16.128v-8.76l6.168 3.84-6.168 4.92zM9.672 12.264l1.8 1.152c0.312 0.192 0.672 0.192 0.984 0l1.8-1.152 7.32 5.784h-19.2l7.296-5.784zM22.080 7.44v8.688l-6.168-4.872 6.168-3.816z"></path></svg>',
		'et_icon-internet'        => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0.072v0c-6.576 0-11.928 5.352-11.928 11.928s5.352 11.928 11.928 11.928c6.576 0 11.928-5.352 11.928-11.928-0.024-6.552-5.376-11.904-11.928-11.928zM12.912 16.488v-3.528h4.152c-0.072 1.392-0.288 2.736-0.648 3.96-1.104-0.216-2.28-0.36-3.504-0.432zM18.84 19.416c-0.672 0.624-1.44 1.152-2.232 1.56 0.432-0.6 0.768-1.248 1.056-1.92 0.432 0.096 0.816 0.216 1.176 0.36zM12.912 21.912v-3.576c0.984 0.024 1.944 0.144 2.88 0.312-0.768 1.68-1.776 2.832-2.88 3.264zM22.008 12.96c-0.144 1.8-0.792 3.528-1.872 4.992-0.672-0.288-1.296-0.504-1.896-0.696 0.384-1.392 0.624-2.832 0.696-4.296h3.072zM17.064 11.112h-4.152v-3.576c1.104-0.048 2.256-0.168 3.504-0.384 0.384 1.272 0.6 2.592 0.648 3.96zM17.64 4.944c-0.264-0.672-0.624-1.32-1.008-1.944 0.816 0.432 1.56 0.936 2.208 1.56-0.408 0.168-0.792 0.288-1.2 0.384zM12.912 5.664v-3.576c1.104 0.408 2.136 1.584 2.88 3.264-0.984 0.192-1.944 0.288-2.88 0.312zM22.008 11.064h-3.096c-0.072-1.464-0.312-2.928-0.696-4.344 0.6-0.168 1.224-0.384 1.896-0.648 1.080 1.464 1.728 3.168 1.896 4.992zM5.76 6.744c-0.384 1.392-0.624 2.832-0.696 4.296h-3.072c0.144-1.8 0.792-3.528 1.872-4.992 0.648 0.288 1.296 0.504 1.896 0.696zM6.936 12.888h4.152v3.552c-1.104 0.048-2.256 0.168-3.504 0.384-0.384-1.272-0.6-2.592-0.648-3.936zM6.336 19.008c0.264 0.672 0.624 1.344 1.056 1.968-0.816-0.408-1.584-0.96-2.256-1.584 0.384-0.144 0.768-0.288 1.2-0.384zM5.112 12.936c0.024 1.44 0.264 2.88 0.672 4.344-0.648 0.168-1.272 0.384-1.872 0.624-1.056-1.464-1.704-3.168-1.872-4.992l3.072 0.024zM5.16 4.584c0.672-0.6 1.416-1.128 2.184-1.536-0.408 0.6-0.744 1.224-1.032 1.92-0.384-0.12-0.768-0.24-1.152-0.384zM11.064 7.512v3.528h-4.128c0.072-1.392 0.288-2.736 0.648-3.96 1.104 0.216 2.256 0.36 3.48 0.432zM8.184 5.352c0.768-1.68 1.776-2.856 2.88-3.264v3.552c-0.984 0-1.944-0.12-2.88-0.288zM11.064 18.336v3.6c-1.104-0.408-2.136-1.584-2.88-3.288 0.96-0.168 1.944-0.288 2.88-0.312z"></path></svg>',
		'et_icon-account'         => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M17.4 12.072c1.344-1.32 2.088-3.12 2.088-4.992 0-3.888-3.144-7.032-7.032-7.032s-7.056 3.144-7.056 7.032c0 1.872 0.744 3.672 2.088 4.992-3.792 1.896-6.312 6.216-6.312 10.92 0 0.576 0.456 1.032 1.032 1.032h20.52c0.576 0 1.032-0.456 1.032-1.032-0.048-4.704-2.568-9.024-6.36-10.92zM14.976 11.4l-0.096 0.024c-0.048 0.024-0.096 0.048-0.144 0.072l-0.024 0.024c-0.744 0.384-1.488 0.576-2.304 0.576-2.76 0-4.992-2.232-4.992-4.992s2.256-5.016 5.016-5.016c2.76 0 4.992 2.232 4.992 4.992 0 1.776-0.936 3.432-2.448 4.32zM9.456 13.44c0.936 0.456 1.944 0.672 2.976 0.672s2.040-0.216 2.976-0.672c3.336 1.104 5.832 4.56 6.192 8.52h-18.336c0.384-3.96 2.88-7.416 6.192-8.52z"></path></svg>',
		'et_icon-home'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.716 9.52l-1.815-1.658v-5.17c0-0.467-0.456-0.793-0.864-0.793l-4.279-0.045c-0.437 0-0.793 0.356-0.793 0.793v0.601l-3.465-2.805c-0.291-0.237-0.712-0.237-0.999-0l-11.208 9.072c-0.338 0.275-0.392 0.775-0.119 1.118 0.151 0.187 0.378 0.294 0.62 0.294 0.184 0 0.361-0.063 0.497-0.177l0.842-0.68v12.872c0 0.437 0.357 0.793 0.795 0.793h6.363c0.461 0 0.836-0.375 0.836-0.836v-8.77h3.748v8.77c0 0.461 0.375 0.836 0.835 0.836h6.363c0.439 0 0.795-0.356 0.795-0.793v-12.872l0.841 0.68c0.166 0.133 0.373 0.195 0.585 0.173 0.195-0.022 0.374-0.115 0.497-0.253l0.036-0.038c0.268-0.337 0.218-0.834-0.112-1.112zM8.538 12.541v9.606h-4.817v-13.359l8.279-6.691 5.553 4.488v-3.139h2.726l0.007 18.701h-4.824v-9.606h-6.924z"></path></svg>',
		'et_icon-shop'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M22.553 20.267v-9.372c0.908-0.676 1.447-1.743 1.447-2.876 0-0.136-0.035-0.27-0.103-0.388l-2.686-4.702c-0.268-0.468-0.769-0.759-1.308-0.759h-15.806c-0.539 0-1.040 0.291-1.307 0.759l-2.687 4.701c-0.067 0.118-0.103 0.252-0.103 0.388 0 1.133 0.539 2.201 1.447 2.876v9.372c-0.404 0.030-0.724 0.368-0.724 0.78 0 0.431 0.351 0.782 0.782 0.782h20.989c0.431 0 0.782-0.351 0.782-0.782 0-0.412-0.32-0.75-0.724-0.78zM18.566 13.143v7.122h-2.779v-7.122h2.779zM2.129 7.237l2.001-3.502h15.739l2.001 3.502h-19.742zM22.279 8.801c-0.312 0.742-1.045 1.241-1.865 1.241s-1.553-0.499-1.865-1.241h3.73zM19.348 11.58h-4.115c0.935-0.112 1.788-0.587 2.376-1.326 0.676 0.851 1.705 1.351 2.804 1.351 0.193 0 0.386-0.015 0.575-0.046v8.706h-0.86v-7.904c0-0.431-0.351-0.781-0.782-0.781zM9.195 10.042c-0.82 0-1.553-0.499-1.865-1.241h3.73c-0.312 0.742-1.045 1.241-1.865 1.241zM14.805 10.042c-0.821 0-1.554-0.499-1.865-1.241h3.73c-0.312 0.742-1.044 1.241-1.865 1.241zM3.011 11.559c0.19 0.031 0.382 0.046 0.575 0.046 1.099 0 2.128-0.5 2.805-1.351 0.676 0.851 1.705 1.351 2.805 1.351s2.128-0.5 2.805-1.351c0.676 0.851 1.705 1.351 2.804 1.351 0.001 0 0.001 0 0.002 0-0.335 0.088-0.583 0.394-0.583 0.756v7.904h-11.212v-8.706zM5.451 8.801c-0.312 0.742-1.045 1.241-1.865 1.241s-1.554-0.499-1.865-1.241h3.73z"></path><path d="M11.843 12.415h-7.46c-0.419 0-0.759 0.341-0.759 0.759v5.25c0 0.419 0.341 0.759 0.759 0.759h7.46c0.419 0 0.759-0.341 0.759-0.759v-5.25c0-0.419-0.341-0.759-0.759-0.759zM5.142 17.665v-3.731h5.941v3.731h-5.941z"></path></svg>',
		'et_icon-sent'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M22.704 6.576l-0.024-0.048c-0.024-0.048-0.048-0.096-0.096-0.144l-3.264-5.64c-0.432-0.744-1.248-0.744-1.656-0.744h-11.328c-0.552 0-1.248 0.096-1.68 0.744l-3.336 5.808c-0.024 0.024-0.048 0.048-0.048 0.096l-0.072 0.072v0.072l-0.024 0.072c-0.048 0.168-0.12 0.384-0.12 0.6v15.024c0 1.536 1.44 1.536 2.208 1.536h17.376c0.84 0 2.208 0 2.208-1.536v-15.12c0.072-0.288 0-0.552-0.144-0.792zM3.624 6.408l2.736-4.656 4.68-0.048v4.656l-7.416 0.048zM12.96 6.408l0.024-4.656h4.824l2.592 4.656h-7.44zM21.072 8.256v13.824h-18.144v-13.824h18.144zM8.136 15.072l2.76 2.856c0.192 0.192 0.432 0.288 0.696 0.288s0.504-0.096 0.696-0.288l4.992-4.848c0.192-0.192 0.288-0.432 0.288-0.72 0-0.24-0.096-0.48-0.264-0.624-0.144-0.192-0.384-0.312-0.624-0.336-0.264-0.024-0.528 0.048-0.768 0.264l-4.296 4.152-2.112-2.16c-0.192-0.192-0.432-0.288-0.72-0.288-0.312 0-0.6 0.144-0.744 0.36-0.192 0.216-0.264 0.504-0.216 0.792 0.024 0.096 0.072 0.384 0.312 0.552z"></path></svg>',
		'et_icon-shopping-bag'    => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M20.304 5.544v0c-0.024-0.696-0.576-1.224-1.272-1.224h-2.304c-0.288-2.424-2.304-4.248-4.728-4.248-2.448 0-4.464 1.824-4.728 4.248h-2.28c-0.696 0-1.272 0.576-1.272 1.248l-0.624 15.936c-0.024 0.648 0.192 1.272 0.624 1.728 0.432 0.48 1.008 0.72 1.68 0.72h13.176c0.624 0 1.2-0.24 1.68-0.72 0.408-0.456 0.624-1.056 0.624-1.704l-0.576-15.984zM9.12 4.296c0.288-1.344 1.464-2.376 2.88-2.376s2.592 1.032 2.88 2.4l-5.76-0.024zM8.184 8.664c0.528 0 0.936-0.408 0.936-0.936v-1.536h5.832v1.536c0 0.528 0.408 0.936 0.936 0.936s0.936-0.408 0.936-0.936v-1.536h1.68l0.576 15.336c-0.024 0.144-0.072 0.288-0.168 0.384s-0.216 0.144-0.312 0.144h-13.2c-0.12 0-0.24-0.048-0.336-0.144-0.072-0.072-0.12-0.192-0.096-0.336l0.6-15.384h1.704v1.536c-0.024 0.528 0.384 0.936 0.912 0.936z"></path></svg>',
		'et_icon-shopping-cart'   => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M0.048 1.872c0 0.504 0.36 0.84 0.84 0.84h2.184l2.28 11.448c0.336 1.704 1.896 3 3.648 3h11.088c0.48 0 0.84-0.36 0.84-0.84 0-0.504-0.36-0.84-0.84-0.84h-10.992c-0.432 0-0.84-0.144-1.176-0.384l13.344-1.824c0.36 0 0.72-0.36 0.744-0.72l1.944-7.704v-0.048c0-0.096-0.024-0.384-0.192-0.552l-0.072-0.048c-0.12-0.096-0.288-0.24-0.6-0.24h-18.024l-0.408-2.16c-0.024-0.432-0.504-0.744-0.84-0.744h-2.904c-0.48-0.024-0.864 0.336-0.864 0.816zM21.912 5.544l-1.44 6.12-13.464 1.752-1.584-7.872h16.488zM5.832 20.184c0 1.56 1.224 2.784 2.784 2.784s2.784-1.224 2.784-2.784-1.224-2.784-2.784-2.784-2.784 1.224-2.784 2.784zM8.616 19.128c0.576 0 1.056 0.504 1.056 1.056s-0.504 1.056-1.056 1.056c-0.552 0-1.056-0.504-1.056-1.056s0.504-1.056 1.056-1.056zM15.48 20.184c0 1.56 1.224 2.784 2.784 2.784s2.784-1.224 2.784-2.784-1.224-2.784-2.784-2.784c-1.56 0-2.784 1.224-2.784 2.784zM18.24 19.128c0.576 0 1.056 0.504 1.056 1.056s-0.504 1.056-1.056 1.056c-0.552 0-1.056-0.504-1.056-1.056s0.504-1.056 1.056-1.056z"></path></svg>',
		'et_icon-shopping-cart-2' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.088 1.032h-2.904c-0.336 0-0.84 0.312-0.84 0.744l-0.408 2.16h-18.024c-0.312 0-0.48 0.144-0.6 0.24l-0.072 0.048c-0.168 0.168-0.192 0.432-0.192 0.552v0.048l1.944 7.704c0.024 0.36 0.36 0.72 0.744 0.72l13.344 1.824c-0.336 0.24-0.744 0.384-1.176 0.384h-10.992c-0.504 0-0.84 0.36-0.84 0.84s0.36 0.84 0.84 0.84h11.088c1.752 0 3.312-1.296 3.648-3l2.256-11.448h2.184c0.504 0 0.84-0.36 0.84-0.84 0.024-0.456-0.36-0.816-0.84-0.816zM18.576 5.544l-1.584 7.872-13.464-1.752-1.44-6.12h16.488zM15.384 17.4c-1.56 0-2.784 1.224-2.784 2.784s1.224 2.784 2.784 2.784 2.784-1.224 2.784-2.784-1.224-2.784-2.784-2.784zM16.44 20.184c0 0.552-0.504 1.056-1.056 1.056s-1.056-0.504-1.056-1.056c0-0.576 0.504-1.056 1.056-1.056s1.056 0.504 1.056 1.056zM5.736 17.4c-1.56 0-2.784 1.224-2.784 2.784s1.224 2.784 2.784 2.784 2.784-1.224 2.784-2.784-1.224-2.784-2.784-2.784zM6.816 20.184c0 0.552-0.504 1.056-1.056 1.056s-1.056-0.504-1.056-1.056c0-0.576 0.504-1.056 1.056-1.056s1.056 0.504 1.056 1.056z"></path></svg>',
		'et_icon-burger'          => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M1.152 6.456h21.696c0.6 0 1.080-0.48 1.080-1.080s-0.48-1.080-1.080-1.080h-21.696c-0.6 0-1.080 0.48-1.080 1.080s0.48 1.080 1.080 1.080zM22.848 10.92h-21.696c-0.6 0-1.080 0.48-1.080 1.080s0.48 1.080 1.080 1.080h21.696c0.6 0 1.080-0.48 1.080-1.080s-0.48-1.080-1.080-1.080zM22.848 17.544h-21.696c-0.6 0-1.080 0.48-1.080 1.080s0.48 1.080 1.080 1.080h21.696c0.6 0 1.080-0.48 1.080-1.080s-0.48-1.080-1.080-1.080z"></path></svg>',
		'et_icon-star'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.856 9.168c-0.216-0.648-0.744-1.056-1.368-1.152l-6.216-0.912-2.76-5.664c-0.312-0.576-0.864-0.936-1.512-0.936-0.624 0-1.224 0.36-1.512 0.936l-2.784 5.664-6.216 0.912c-0.648 0.096-1.152 0.528-1.368 1.152s-0.048 1.32 0.456 1.776l4.464 4.368-1.080 6.168c-0.096 0.504 0.048 1.008 0.408 1.416 0.336 0.384 0.816 0.576 1.32 0.576 0.264 0 0.504-0.048 0.744-0.168l5.568-2.976 5.592 2.928c0.24 0.12 0.504 0.192 0.768 0.192 0.48 0 0.936-0.192 1.272-0.576 0.336-0.408 0.48-0.888 0.384-1.392l-1.056-6.216 4.464-4.368c0.48-0.432 0.648-1.080 0.432-1.728zM17.16 14.232c-0.216 0.216-0.336 0.552-0.288 0.864l1.056 6.096-5.448-2.856c-0.144-0.072-0.312-0.12-0.456-0.12-0.168 0-0.312 0.048-0.456 0.12l-5.496 2.832 1.056-6.048c0.072-0.336-0.048-0.672-0.288-0.888l-4.44-4.296 6.096-0.888c0.336-0.048 0.648-0.264 0.768-0.576l2.736-5.544 2.736 5.544c0.144 0.288 0.456 0.528 0.744 0.552l6.12 0.888-4.44 4.32z"></path></svg>',
		'et_icon-time'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0c-6.617 0-12 5.383-12 12s5.383 12 12 12 12-5.383 12-12-5.383-12-12-12zM12 22.076c-5.556 0-10.075-4.52-10.075-10.076s4.52-10.075 10.075-10.075c5.556 0 10.076 4.52 10.076 10.075s-4.52 10.076-10.076 10.076z"></path><path d="M12 2.284c-0.53 0-0.962 0.432-0.962 0.962v8.173h-5.128c-0.53 0-0.962 0.432-0.962 0.963s0.432 0.962 0.962 0.962h6.090c0.53 0 0.962-0.431 0.962-0.962v-9.135c0-0.53-0.432-0.962-0.962-0.962z"></path></svg>',
		'et_icon-size'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M22.876 15.857l-10.005-5.286v-0.153c1.673-0.501 2.703-1.633 2.703-2.988 0-1.696-1.38-3.076-3.076-3.076-1.587 0-2.934 1.183-3.063 2.67-0.007 0.039-0.011 0.080-0.012 0.137 0 0.48 0.391 0.871 0.871 0.871 0.415 0 0.774-0.295 0.857-0.719l0.015-0.116c0.029-0.315 0.188-0.541 0.316-0.675 0.258-0.27 0.628-0.426 1.016-0.426 0.736 0 1.334 0.599 1.334 1.335 0 0.258-0.109 0.491-0.334 0.71-0.301 0.294-0.761 0.524-1.347 0.67-0.744 0.23-0.755 0.233-0.763 0.237l-0.257 0.091-0.001 1.433-10.002 5.285c-0.695 0.358-1.127 1.034-1.127 1.764 0 1.116 0.992 2.024 2.212 2.024h19.577c1.219 0 2.211-0.908 2.211-2.024 0-0.73-0.431-1.405-1.124-1.763zM22.259 17.621c0 0.114-0.197 0.282-0.47 0.282h-19.577c-0.273 0-0.47-0.168-0.47-0.282 0-0.073 0.069-0.159 0.172-0.213l10.085-5.326 10.075 5.321c0.112 0.058 0.184 0.144 0.184 0.218z"></path></svg>',
		'et_icon-more'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M3.672 8.424c-1.968 0-3.576 1.608-3.576 3.576s1.608 3.576 3.6 3.576 3.6-1.608 3.6-3.576c0-1.944-1.656-3.576-3.624-3.576zM3.672 10.272c0.96 0 1.728 0.768 1.728 1.728s-0.768 1.728-1.728 1.728-1.728-0.768-1.728-1.728 0.792-1.728 1.728-1.728zM20.328 8.424c-1.968 0-3.576 1.608-3.576 3.576 0 1.944 1.632 3.576 3.576 3.576s3.6-1.632 3.6-3.576c0-1.968-1.608-3.576-3.6-3.576zM22.056 12c0 0.96-0.768 1.728-1.728 1.728s-1.728-0.768-1.728-1.728 0.768-1.728 1.728-1.728 1.728 0.768 1.728 1.728zM12 8.424c-1.968 0-3.576 1.608-3.576 3.576 0 1.944 1.632 3.576 3.576 3.576s3.576-1.632 3.576-3.576c0-1.968-1.608-3.576-3.576-3.576zM13.728 12c0 0.96-0.768 1.728-1.728 1.728s-1.728-0.768-1.728-1.728 0.768-1.728 1.728-1.728c0.96 0 1.728 0.768 1.728 1.728z"></path></svg>'
	),
);

$et_social_icons = array(
	'type1' => array(
		'et_icon-facebook'    => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M13.488 8.256v-3c0-0.84 0.672-1.488 1.488-1.488h1.488v-3.768h-2.976c-2.472 0-4.488 2.016-4.488 4.512v3.744h-3v3.744h3v12h4.512v-12h3l1.488-3.744h-4.512z"></path></svg>',
		'et_icon-twitter'     => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M24 4.56c-0.888 0.384-1.848 0.648-2.832 0.768 1.032-0.6 1.8-1.56 2.16-2.712-0.96 0.576-1.992 0.96-3.12 1.2-0.912-0.96-2.184-1.56-3.6-1.56-2.712 0-4.92 2.208-4.92 4.92 0 0.384 0.024 0.768 0.12 1.128-4.080-0.192-7.704-2.16-10.152-5.136-0.432 0.744-0.672 1.584-0.672 2.496 0 1.704 0.888 3.216 2.184 4.080-0.768-0.024-1.56-0.264-2.208-0.624 0 0.024 0 0.024 0 0.048 0 2.4 1.704 4.368 3.936 4.824-0.384 0.12-0.84 0.168-1.296 0.168-0.312 0-0.624-0.024-0.936-0.072 0.648 1.944 2.448 3.384 4.608 3.432-1.68 1.32-3.792 2.088-6.096 2.088-0.408 0-0.792-0.024-1.176-0.072 2.184 1.416 4.752 2.208 7.56 2.208 9.048 0 14.016-7.512 14.016-13.992 0-0.216 0-0.432-0.024-0.624 0.96-0.72 1.776-1.584 2.448-2.568z"></path></svg>',
		'et_icon-instagram'   => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M16.512 0h-9.024c-4.128 0-7.488 3.36-7.488 7.488v9c0 4.152 3.36 7.512 7.488 7.512h9c4.152 0 7.512-3.36 7.512-7.488v-9.024c0-4.128-3.36-7.488-7.488-7.488zM21.744 16.512c0 2.904-2.352 5.256-5.256 5.256h-9c-2.904 0-5.256-2.352-5.256-5.256v-9.024c0-2.904 2.352-5.256 5.256-5.256h9c2.904 0 5.256 2.352 5.256 5.256v9.024zM12 6c-3.312 0-6 2.688-6 6s2.688 6 6 6 6-2.688 6-6-2.688-6-6-6zM12 15.744c-2.064 0-3.744-1.68-3.744-3.744s1.68-3.744 3.744-3.744 3.744 1.68 3.744 3.744c0 2.064-1.68 3.744-3.744 3.744zM19.248 5.544c0 0.437-0.355 0.792-0.792 0.792s-0.792-0.355-0.792-0.792c0-0.437 0.355-0.792 0.792-0.792s0.792 0.355 0.792 0.792z"></path></svg>',
		'et_icon-youtube'     => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M21.768 12.144c-0.24-1.080-1.128-1.872-2.184-1.992-2.52-0.288-5.064-0.288-7.584-0.288s-5.064 0-7.584 0.288c-1.056 0.12-1.944 0.912-2.184 1.992-0.36 1.536-0.36 3.216-0.36 4.8s0 3.264 0.36 4.8c0.24 1.080 1.128 1.872 2.184 1.992 2.52 0.264 5.040 0.264 7.584 0.264 2.52 0 5.064 0 7.584-0.288 1.056-0.12 1.944-0.912 2.184-1.992 0.36-1.536 0.36-3.216 0.36-4.8 0-1.56 0-3.24-0.36-4.776zM7.656 13.344h-1.464v7.776h-1.368v-7.776h-1.44v-1.272h4.272v1.272zM11.352 21.12h-1.224v-0.72c-0.48 0.552-0.96 0.84-1.392 0.84-0.384 0-0.672-0.168-0.792-0.504-0.072-0.216-0.096-0.528-0.096-1.008v-5.352h1.224v4.968c0 0.288 0 0.432 0 0.48 0.024 0.192 0.12 0.288 0.288 0.288 0.24 0 0.504-0.192 0.768-0.576v-5.16h1.224v6.744zM16.008 19.104c0 0.624-0.048 1.080-0.12 1.368-0.168 0.504-0.48 0.768-0.984 0.768-0.432 0-0.864-0.24-1.272-0.744v0.624h-1.224v-9.048h1.224v2.952c0.384-0.48 0.816-0.744 1.272-0.744 0.48 0 0.816 0.264 0.984 0.768 0.072 0.264 0.12 0.72 0.12 1.368v2.688zM20.616 17.976h-2.448v1.2c0 0.624 0.216 0.936 0.624 0.936 0.312 0 0.48-0.168 0.552-0.48 0-0.072 0.024-0.336 0.024-0.84h1.248v0.168c0 0.384-0.024 0.672-0.024 0.792-0.048 0.264-0.144 0.528-0.288 0.744-0.336 0.48-0.84 0.744-1.488 0.744s-1.128-0.24-1.488-0.696c-0.264-0.336-0.384-0.864-0.384-1.584v-2.376c0-0.72 0.12-1.248 0.384-1.584 0.36-0.456 0.84-0.696 1.464-0.696s1.104 0.24 1.44 0.696c0.264 0.336 0.384 0.864 0.384 1.584v1.392zM18.792 15.384c-0.408 0-0.624 0.312-0.624 0.936v0.624h1.224v-0.624c0-0.624-0.192-0.936-0.6-0.936zM14.232 15.384c-0.192 0-0.408 0.096-0.6 0.288v4.128c0.216 0.216 0.408 0.312 0.6 0.312 0.36 0 0.528-0.312 0.528-0.912v-2.88c0.024-0.624-0.168-0.936-0.528-0.936zM14.928 9.264c0.456 0 0.912-0.264 1.416-0.84v0.744h1.248v-6.84h-1.248v5.208c-0.264 0.384-0.528 0.576-0.792 0.576-0.168 0-0.264-0.096-0.288-0.288-0.024-0.048-0.024-0.192-0.024-0.48v-5.016h-1.224v5.4c0 0.48 0.048 0.816 0.12 1.008 0.12 0.36 0.384 0.528 0.792 0.528zM6.312 5.448v3.72h1.368v-3.72l1.656-5.448h-1.392l-0.936 3.6-0.96-3.6h-1.44c0.288 0.84 0.6 1.704 0.888 2.544 0.408 1.296 0.696 2.256 0.816 2.904zM11.184 9.264c0.624 0 1.104-0.24 1.44-0.696 0.264-0.336 0.384-0.888 0.384-1.608v-2.4c0-0.72-0.12-1.272-0.384-1.608-0.336-0.456-0.816-0.696-1.44-0.696s-1.104 0.24-1.44 0.696c-0.264 0.336-0.384 0.888-0.384 1.608v2.4c0 0.72 0.12 1.272 0.384 1.608 0.336 0.456 0.816 0.696 1.44 0.696zM10.584 4.32c0-0.624 0.192-0.936 0.6-0.936s0.6 0.312 0.6 0.936v2.88c0 0.624-0.192 0.936-0.6 0.936s-0.6-0.312-0.6-0.936v-2.88z"></path></svg>',
		'et_icon-linkedin'    => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M0 7.488h5.376v16.512h-5.376v-16.512zM19.992 7.704c-0.048-0.024-0.12-0.048-0.168-0.048-0.072-0.024-0.144-0.024-0.216-0.048-0.288-0.048-0.6-0.096-0.96-0.096-3.12 0-5.112 2.28-5.76 3.144v-3.168h-5.4v16.512h5.376v-9c0 0 4.056-5.64 5.76-1.488 0 3.696 0 10.512 0 10.512h5.376v-11.16c0-2.496-1.704-4.56-4.008-5.16zM5.232 2.616c0 1.445-1.171 2.616-2.616 2.616s-2.616-1.171-2.616-2.616c0-1.445 1.171-2.616 2.616-2.616s2.616 1.171 2.616 2.616z"></path></svg>',
		'et_icon-behance'     => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M9.888 11.28c0.504-0.24 0.864-0.528 1.128-0.816 0.456-0.552 0.672-1.248 0.672-2.136 0-0.864-0.216-1.608-0.672-2.232-0.744-1.008-2.016-1.536-3.816-1.56h-7.152v14.568h6.672c0.744 0 1.44-0.072 2.088-0.192 0.648-0.144 1.2-0.384 1.656-0.72 0.408-0.312 0.768-0.696 1.056-1.152 0.432-0.672 0.648-1.464 0.648-2.328 0-0.84-0.192-1.56-0.576-2.136-0.384-0.6-0.96-1.032-1.704-1.296zM3 7.056h3.216c0.696 0 1.296 0.072 1.752 0.216 0.528 0.216 0.792 0.672 0.792 1.344 0 0.6-0.192 1.032-0.6 1.272s-0.912 0.36-1.56 0.36h-3.6v-3.192zM8.088 16.32c-0.36 0.168-0.864 0.264-1.488 0.264h-3.6v-3.888h3.624c0.624 0 1.128 0.096 1.488 0.24 0.624 0.288 0.936 0.792 0.936 1.56 0 0.888-0.312 1.488-0.96 1.824zM15.312 5.208h6.336v1.824h-6.336v-1.824zM23.856 12.36c-0.12-0.84-0.432-1.584-0.864-2.232-0.504-0.72-1.128-1.248-1.896-1.584s-1.608-0.504-2.568-0.504c-1.608 0-2.904 0.504-3.912 1.488s-1.512 2.424-1.512 4.296c0 1.992 0.552 3.432 1.656 4.32s2.4 1.32 3.84 1.32c1.752 0 3.12-0.528 4.104-1.56 0.624-0.648 0.984-1.32 1.056-1.944h-2.88c-0.168 0.312-0.36 0.552-0.6 0.744-0.408 0.336-0.936 0.504-1.584 0.504-0.624 0-1.128-0.144-1.584-0.408-0.72-0.432-1.104-1.2-1.152-2.28h7.944c0.048-0.936 0.024-1.656-0.048-2.16zM16.056 12.648c0.096-0.696 0.36-1.248 0.768-1.656s0.984-0.624 1.704-0.624c0.672 0 1.248 0.192 1.704 0.576s0.696 0.96 0.768 1.704h-4.944z"></path></svg>',
		'et_icon-houzz'       => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 16.008v7.992l7.488-4.008v-7.992zM12 0l-7.488 4.008v15.984l7.488-3.984-7.488-4.008 7.488-4.008zM12 7.992l7.488 4.008v-7.992z"></path></svg>',
		'et_icon-pinterest'   => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12.336 0c-6.576 0-10.080 4.224-10.080 8.808 0 2.136 1.2 4.8 3.096 5.64 0.288 0.12 0.456 0.072 0.504-0.192 0.048-0.216 0.312-1.176 0.432-1.656 0.048-0.144 0.024-0.288-0.096-0.408-0.624-0.744-1.128-2.064-1.128-3.312 0-3.216 2.544-6.312 6.888-6.312 3.744 0 6.384 2.448 6.384 5.928 0 3.936-2.088 6.672-4.8 6.672-1.488 0-2.616-1.176-2.256-2.64 0.432-1.728 1.272-3.6 1.272-4.848 0-1.128-0.624-2.040-1.92-2.040-1.536 0-2.76 1.512-2.76 3.528 0 1.296 0.456 2.16 0.456 2.16s-1.512 6.096-1.8 7.224c-0.48 1.92 0.072 5.040 0.12 5.328 0.024 0.144 0.192 0.192 0.288 0.072 0.144-0.192 1.968-2.808 2.496-4.68 0.192-0.696 0.96-3.456 0.96-3.456 0.504 0.912 1.944 1.68 3.504 1.68 4.608 0 7.92-4.032 7.92-9.048-0.072-4.848-4.2-8.448-9.48-8.448z"></path></svg>',
		'et_icon-rss'         => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M6.864 20.568c0 1.895-1.537 3.432-3.432 3.432s-3.432-1.537-3.432-3.432c0-1.895 1.537-3.432 3.432-3.432s3.432 1.537 3.432 3.432zM0 7.992v4.56c6.312 0 11.424 5.136 11.424 11.424h4.56c0.024-8.808-7.152-15.984-15.984-15.984zM0 0v4.584c10.704 0 19.44 8.712 19.44 19.416h4.56c0-13.224-10.776-24-24-24z"></path></svg>',
		'et_icon-skype'       => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.28 14.544c0.168-0.768 0.264-1.584 0.264-2.424 0-6.216-5.112-11.256-11.4-11.256-0.672 0-1.32 0.048-1.944 0.168-1.008-0.624-2.232-1.008-3.528-1.008-3.672 0.024-6.624 2.928-6.624 6.552 0 1.2 0.336 2.328 0.912 3.288-0.144 0.72-0.24 1.488-0.24 2.256 0 6.216 5.112 11.256 11.4 11.256 0.72 0 1.416-0.072 2.088-0.192 0.936 0.504 1.992 0.768 3.12 0.768 3.648 0 6.624-2.928 6.624-6.528 0-1.032-0.24-2.016-0.672-2.88zM17.976 17.496c-0.528 0.744-1.296 1.32-2.328 1.728-1.008 0.408-2.208 0.624-3.576 0.624-1.632 0-3.024-0.288-4.080-0.84-0.768-0.408-1.392-0.96-1.872-1.656s-0.72-1.368-0.72-2.040c0-0.408 0.168-0.768 0.48-1.056s0.72-0.432 1.2-0.432c0.384 0 0.72 0.12 1.008 0.336 0.264 0.216 0.48 0.552 0.672 0.96 0.192 0.456 0.432 0.84 0.648 1.152 0.216 0.288 0.552 0.528 0.96 0.744 0.408 0.192 0.96 0.288 1.656 0.288 0.936 0 1.728-0.192 2.304-0.6 0.576-0.384 0.84-0.84 0.84-1.392 0-0.432-0.144-0.792-0.432-1.056-0.312-0.288-0.72-0.504-1.224-0.672-0.528-0.168-1.224-0.336-2.088-0.504-1.176-0.24-2.184-0.552-3-0.888s-1.488-0.816-1.968-1.416c-0.48-0.6-0.744-1.368-0.744-2.256 0-0.84 0.264-1.608 0.768-2.28 0.504-0.648 1.248-1.176 2.208-1.512 0.936-0.336 2.064-0.528 3.336-0.528 1.008 0 1.92 0.12 2.664 0.336 0.744 0.24 1.392 0.552 1.872 0.936 0.504 0.384 0.888 0.792 1.104 1.224 0.24 0.432 0.36 0.864 0.36 1.272s-0.168 0.768-0.456 1.080c-0.312 0.312-0.72 0.48-1.176 0.48-0.432 0-0.744-0.096-0.984-0.312-0.216-0.192-0.432-0.48-0.672-0.888-0.288-0.528-0.624-0.96-1.032-1.248-0.384-0.288-1.032-0.432-1.896-0.432-0.816 0-1.488 0.168-1.968 0.48s-0.696 0.648-0.696 1.080c0 0.264 0.072 0.48 0.24 0.648 0.168 0.192 0.384 0.36 0.672 0.504s0.6 0.264 0.912 0.36c0.312 0.096 0.84 0.216 1.584 0.384 0.912 0.192 1.776 0.408 2.52 0.648 0.768 0.24 1.416 0.528 1.944 0.888 0.552 0.36 0.984 0.792 1.296 1.344s0.456 1.2 0.456 1.992c0 0.936-0.264 1.776-0.792 2.52z"></path></svg>',
		'et_icon-snapchat'    => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M5.88 4.608c-0.6 1.32-0.36 3.72-0.264 5.376-0.648 0.36-1.464-0.264-1.92-0.264-0.48 0-1.056 0.312-1.152 0.792-0.072 0.336 0.096 0.84 1.2 1.272 0.432 0.168 1.44 0.36 1.68 0.912 0.336 0.768-1.704 4.368-4.872 4.872-0.24 0.048-0.432 0.264-0.408 0.504 0.048 0.96 2.208 1.344 3.168 1.488 0.096 0.144 0.168 0.696 0.312 1.128 0.048 0.192 0.192 0.408 0.576 0.408 0.48 0 1.296-0.384 2.712-0.144 1.392 0.24 2.688 2.184 5.184 2.184 2.328 0 3.696-1.968 5.040-2.184 0.768-0.12 1.44-0.096 2.184 0.048 0.504 0.096 0.96 0.144 1.104-0.336 0.12-0.432 0.216-0.984 0.312-1.104 0.96-0.144 3.12-0.528 3.168-1.488 0.024-0.24-0.168-0.48-0.408-0.504-3.12-0.504-5.208-4.080-4.872-4.872 0.24-0.552 1.248-0.744 1.68-0.912 0.816-0.312 1.2-0.72 1.2-1.152 0-0.576-0.696-0.936-1.224-0.936s-1.272 0.624-1.872 0.288c0.096-1.68 0.336-4.056-0.264-5.376-1.152-2.52-3.648-3.792-6.168-3.792-2.472 0-4.944 1.248-6.096 3.792z"></path></svg>',
		'et_icon-tripadvisor' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M14.712 5.112c0.672 0.096 1.32 0.264 1.968 0.456 1.128 0.36 2.208 0.84 3.192 1.464 0.072 0.048 0.168 0.072 0.24 0.072 1.176 0 2.352 0 3.528 0 0.096 0 0.192 0 0.288 0.024 0 0.024 0 0.024 0 0.048-0.048 0.096-0.12 0.168-0.168 0.264-0.408 0.624-0.744 1.248-0.936 1.968-0.024 0.072-0.024 0.144 0.024 0.216 1.056 1.512 1.392 3.168 0.936 4.944-0.384 1.56-1.272 2.784-2.64 3.648-0.984 0.624-2.040 0.912-3.192 0.912-0.48 0-0.96-0.072-1.44-0.192-1.152-0.288-2.136-0.864-2.952-1.728-0.096-0.12-0.216-0.24-0.312-0.36-0.432 0.648-0.864 1.272-1.296 1.92-0.432-0.648-0.84-1.272-1.272-1.896-0.024 0.024-0.048 0.024-0.048 0.024s-0.024 0.024-0.024 0.024c-0.984 1.152-2.208 1.872-3.72 2.112-0.84 0.144-1.656 0.096-2.472-0.144-1.152-0.312-2.136-0.936-2.928-1.824-0.768-0.888-1.248-1.896-1.44-3.048-0.216-1.080 0.048-2.112 0.096-2.376 0.192-0.744 0.504-1.416 0.936-2.040 0.024-0.048 0.048-0.12 0.024-0.168-0.168-0.648-0.48-1.248-0.84-1.824-0.096-0.144-0.192-0.288-0.312-0.408 0-0.024 0-0.024 0-0.048 0.024 0 0.048 0 0.048 0 1.2 0 2.424 0 3.624 0 0.048 0 0.12-0.024 0.144-0.048 0.84-0.552 1.752-0.984 2.712-1.32 0.696-0.24 1.392-0.432 2.088-0.576s1.392-0.216 2.088-0.264c1.776-0.144 3.144 0.048 4.056 0.168zM13.2 13.080c0 2.64 2.16 4.824 4.8 4.8 2.64 0 4.8-2.112 4.8-4.8 0-2.76-2.232-4.848-4.896-4.776-2.64 0.072-4.68 2.16-4.704 4.776zM6 8.304c-2.568-0.024-4.824 2.112-4.776 4.848 0.048 2.544 2.16 4.728 4.824 4.704 2.616-0.024 4.728-2.16 4.752-4.752 0-2.664-2.136-4.8-4.8-4.8zM6.24 7.032c1.464 0.096 2.736 0.6 3.816 1.584s1.704 2.208 1.944 3.648c0.24-1.416 0.84-2.64 1.92-3.6 1.056-0.984 2.328-1.488 3.744-1.584-1.704-0.744-3.48-1.080-5.328-1.104-2.112-0.048-4.152 0.24-6.096 1.056zM17.976 10.056c1.632 0 2.976 1.32 2.976 2.952 0 1.656-1.296 2.904-2.856 2.976-1.728 0.072-3.096-1.296-3.096-2.976 0-1.656 1.392-2.976 2.976-2.952zM19.92 13.032c0-1.080-0.864-1.944-1.92-1.944-1.080 0-1.944 0.864-1.944 1.92s0.864 1.944 1.944 1.944c1.032 0.024 1.92-0.864 1.92-1.92zM5.952 10.056c1.632 0 2.976 1.32 2.976 2.952 0 1.656-1.32 2.904-2.832 2.976-1.728 0.072-3.12-1.296-3.12-2.976s1.392-2.976 2.976-2.952zM7.872 13.008c0-1.080-0.864-1.944-1.968-1.92-1.056 0-1.92 0.888-1.92 1.944s0.888 1.944 1.944 1.944c1.080 0 1.944-0.888 1.944-1.968zM17.976 12.048c0.552 0 0.984 0.456 0.984 0.984 0 0.552-0.432 0.984-0.984 0.984s-0.984-0.432-0.984-0.984c0-0.552 0.432-0.984 0.984-0.984zM5.952 12.024c0.552 0 0.984 0.432 1.008 0.984 0 0.552-0.456 0.984-0.984 0.984-0.552 0-0.984-0.432-0.984-1.008-0.048-0.528 0.384-0.96 0.96-0.96z"></path></svg>',
		'et_icon-tumblr'      => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M16.32 20.016c-0.672 0-1.272-0.144-1.8-0.456-0.408-0.24-0.768-0.648-0.912-1.032s-0.12-1.2-0.12-2.568v-5.448h5.952v-4.464h-5.952v-5.952h-3.84c-0.144 1.224-0.432 2.232-0.84 3.024-0.384 0.792-0.936 1.488-1.584 2.040-0.672 0.576-1.704 1.008-2.664 1.296v3.384h3.192v8.352c0 1.104 0.12 1.92 0.336 2.496 0.24 0.576 0.624 1.104 1.224 1.632 0.6 0.504 1.296 0.912 2.136 1.176 0.816 0.264 1.464 0.408 2.568 0.408 0.96 0 1.848-0.096 2.664-0.288s1.704-0.48 2.736-0.936v-3.6c-1.176 0.792-1.896 0.936-3.096 0.936z"></path></svg>',
		'et_icon-vimeo'       => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M20.448 1.68c-3.336-0.12-5.568 1.752-6.744 5.568 0.6-0.24 1.2-0.384 1.776-0.384 1.2 0 1.752 0.672 1.608 2.040-0.072 0.816-0.6 2.016-1.608 3.6s-1.752 2.352-2.232 2.352c-0.648 0-1.224-1.224-1.776-3.648-0.168-0.72-0.504-2.544-0.96-5.472-0.432-2.712-1.584-3.984-3.432-3.792-0.792 0.072-1.968 0.792-3.528 2.136-1.152 1.032-2.304 2.088-3.48 3.12l1.128 1.44c1.080-0.744 1.704-1.128 1.872-1.128 0.816 0 1.584 1.296 2.304 3.864 0.648 2.376 1.272 4.728 1.92 7.080 0.96 2.568 2.136 3.864 3.528 3.864 2.256 0 4.992-2.112 8.232-6.336 3.144-4.032 4.752-7.224 4.872-9.552 0.12-3.096-1.032-4.68-3.48-4.752z"></path></svg>',
		'et_icon-vk'          => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.784 17.376c-0.072-0.12-0.456-0.984-2.376-2.76-2.016-1.872-1.752-1.56 0.672-4.8 1.464-1.968 2.064-3.168 1.872-3.672-0.168-0.48-1.272-0.36-1.272-0.36l-3.6 0.024c0 0-0.264-0.048-0.456 0.072s-0.312 0.384-0.312 0.384-0.576 1.512-1.344 2.808c-1.608 2.736-2.256 2.88-2.52 2.712-0.6-0.384-0.456-1.584-0.456-2.424 0-2.64 0.408-3.744-0.792-4.032-0.384-0.096-0.672-0.168-1.68-0.168-1.296-0.024-2.376 0-3 0.312-0.408 0.192-0.72 0.648-0.528 0.672 0.24 0.024 0.768 0.144 1.056 0.528 0.36 0.504 0.36 1.632 0.36 1.632s0.216 3.12-0.504 3.504c-0.48 0.264-1.152-0.288-2.592-2.76-0.744-1.272-1.296-2.664-1.296-2.664s-0.096-0.264-0.288-0.408c-0.24-0.168-0.552-0.216-0.552-0.216l-3.384 0.024c0 0-0.504 0.024-0.696 0.24-0.168 0.192-0.024 0.6-0.024 0.6s2.688 6.288 5.712 9.456c2.784 2.904 5.952 2.712 5.952 2.712h1.44c0 0 0.432-0.048 0.648-0.288 0.216-0.216 0.192-0.624 0.192-0.624s-0.024-1.92 0.864-2.208c0.888-0.288 2.016 1.872 3.216 2.688 0.912 0.624 1.584 0.48 1.584 0.48l3.216-0.048c0 0 1.68-0.096 0.888-1.416z"></path></svg>',
		'et_icon-whatsapp'    => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.952 11.688c0 6.432-5.256 11.64-11.712 11.64-2.064 0-3.984-0.528-5.664-1.44l-6.48 2.064 2.112-6.24c-1.056-1.752-1.68-3.816-1.68-6 0-6.432 5.256-11.64 11.712-11.64 6.456-0.024 11.712 5.184 11.712 11.616zM12.216 1.92c-5.424 0-9.864 4.368-9.864 9.768 0 2.136 0.696 4.128 1.872 5.736l-1.224 3.624 3.792-1.2c1.56 1.032 3.432 1.608 5.424 1.608 5.424 0.024 9.864-4.368 9.864-9.768s-4.44-9.768-9.864-9.768zM18.144 14.376c-0.072-0.12-0.264-0.192-0.552-0.336s-1.704-0.84-1.968-0.936c-0.264-0.096-0.456-0.144-0.648 0.144s-0.744 0.936-0.912 1.128c-0.168 0.192-0.336 0.216-0.624 0.072s-1.224-0.432-2.304-1.416c-0.864-0.744-1.44-1.68-1.608-1.968s-0.024-0.432 0.12-0.576c0.12-0.12 0.288-0.336 0.432-0.504s0.192-0.288 0.288-0.48c0.096-0.192 0.048-0.36-0.024-0.504s-0.648-1.536-0.888-2.112c-0.24-0.576-0.48-0.48-0.648-0.48s-0.36-0.024-0.552-0.024c-0.192 0-0.504 0.072-0.768 0.36s-1.008 0.984-1.008 2.376c0 1.392 1.032 2.76 1.176 2.952s1.992 3.168 4.92 4.296c2.928 1.152 2.928 0.768 3.456 0.72s1.704-0.696 1.944-1.344c0.24-0.672 0.24-1.248 0.168-1.368z"></path></svg>',
		'et_icon-etsy'        => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" x="0px" y="0px" viewBox="0 0 24 24" style="enable-background:new 0 0 24 24;" xml:space="preserve"><path d="M20.7301502,16.9833183l-0.8190193,2.6339951c-0.4364929,1.403595-1.7354202,2.3600121-3.2052994,2.3600121h-6.2712927c-0.9309654,0-1.685605-0.7547073-1.685605-1.685606v-7.0764303h4.5399551c1.1916084,0,2.1576223,0.966013,2.1576223,2.1576223v0.5553131c0,0.1649609,0.1337233,0.2986851,0.2986841,0.2986851h0.9308968c0.1649609,0,0.2986851-0.1337242,0.2986851-0.2986851V7.7604299c0-0.1649609-0.1337242-0.2986851-0.2986851-0.2986851h-0.9308977c-0.1649609,0-0.2986841,0.1337242-0.2986841,0.2986851v0.8699899c0,1.1916084-0.9660139,2.1576223-2.1576223,2.1576223H8.7489347V3.7083468c0-0.9309657,0.7547083-1.685606,1.685606-1.685606h5.9558668c1.539156,0,2.7869091,1.2477524,2.7869091,2.7869086V6.48879c0,0.1649609,0.1337223,0.2986851,0.2986851,0.2986851h1.0885067c0.1557751,0,0.2854156-0.1197057,0.2977333-0.2750707l0.4584732-5.7687888C21.352562,0.3427832,21.0359135,0,20.6338558,0H1.7178295C1.4551446,0,1.2422067,0.212938,1.2422067,0.4756227v1.0714952c0,0.2626848,0.212938,0.4756229,0.4756228,0.4756229h1.2099831c0.9309659,0,1.685606,0.7547083,1.685606,1.6856058v16.5833035c0,0.9309654-0.7547085,1.685606-1.685606,1.685606H1.7178293c-0.2626848,0-0.4756228,0.2129383-0.4756228,0.4756241v1.0714951C1.2422066,23.7870598,1.4551445,24,1.7178293,24h19.0681934c0.3412189,0,0.6310558-0.2497559,0.6814842-0.5872974l0.939949-6.296608c0.0269489-0.1805458-0.1128998-0.3427849-0.2954178-0.3427849h-1.0966091C20.8845634,16.7733078,20.7690086,16.8583736,20.7301502,16.9833183z"/></svg>',
		'et_icon-tik-tok'     => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" x="0px" y="0px" viewBox="0 0 24 24" style="enable-background:new 0 0 24 24;" xml:space="preserve"><g><path d="M22.5316296,6.0092726c-1.3718052,0-2.6375065-0.4544511-3.6539211-1.2211032c-1.1657028-0.8788559-2.0032463-2.1680326-2.299015-3.6539192C16.505455,0.7671212,16.4660187,0.3882553,16.4622631,0H12.54356 v10.7077723l-0.0046949,5.8651438c0,1.5680447-1.0211077,2.8975964-2.4365721,3.3651924 c-0.4107904,0.1356792-0.8544436,0.1999969-1.3164072,0.1746445c-0.5896597-0.0323944-1.142231-0.2103252-1.6225028-0.4976444 c-1.0220461-0.6112537-1.7149901-1.7201519-1.7337694-2.9886742c-0.0295768-1.9825897,1.5732088-3.5989904,3.5543904-3.5989904 c0.3910723,0,0.7666521,0.0638485,1.118289,0.1798086V10.280549V9.2284565 C9.7314081,9.1735287,9.3539505,9.1448908,8.9722672,9.1448908c-2.1685019,0-4.1966314,0.9013901-5.646368,2.5253029 c-1.0957532,1.2272062-1.7530174,2.7929029-1.8544239,4.4346552c-0.1328613,2.156765,0.6563252,4.2069607,2.1868119,5.7196064 c0.2248783,0.2220612,0.4610238,0.4281597,0.7079673,0.6182976C5.6784358,23.4525928,7.2826295,24,8.9722672,24 c0.3816833,0,0.75914-0.0281696,1.1300259-0.0830956c1.578373-0.233799,3.0346813-0.9563198,4.1839552-2.0924492 c1.412179-1.3957481,2.1924467-3.2487621,2.2008963-5.2210236l-0.0201874-8.7585144 c0.6736965,0.5197091,1.4103012,0.9497466,2.2008972,1.2835431c1.2295532,0.5187693,2.5332832,0.7816744,3.875042,0.7812052 V7.0641809V6.0083327c0.0009384,0.0009389-0.0103283,0.0009389-0.0112667,0.0009389V6.0092726z"/></g></svg>'
	),
	'type2' => array(
		'et_icon-facebook'    => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0c-6.624 0-12 5.376-12 12s5.376 12 12 12 12-5.376 12-12-5.376-12-12-12zM16.584 6.12h-1.656c-1.296 0-1.56 0.624-1.56 1.536v1.992h3.096v3.144h-3.096v8.040h-3.24v-8.064h-2.712v-3.12h2.712v-2.304c0-2.688 1.632-4.152 4.032-4.152h2.424v2.928z"></path></svg>',
		'et_icon-twitter'     => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0c-6.624 0-12 5.376-12 12s5.376 12 12 12 12-5.376 12-12-5.376-12-12-12zM19.248 8.808c0 0.144 0 0.288 0 0.432 0 5.136-3.912 10.44-10.44 10.44-1.992 0-3.936-0.576-5.616-1.656-0.024-0.024-0.048-0.072-0.024-0.096 0.024-0.048 0.048-0.072 0.096-0.048 0.288 0.024 0.576 0.048 0.864 0.048 1.56 0 3.024-0.48 4.272-1.392-1.488-0.168-2.784-1.176-3.24-2.616 0-0.024 0-0.072 0.024-0.096s0.048-0.024 0.072-0.024c0.408 0.072 0.84 0.072 1.248 0.024-1.536-0.48-2.616-1.92-2.616-3.552v-0.048c0-0.024 0.024-0.048 0.048-0.072s0.072-0.024 0.096 0c0.408 0.216 0.84 0.36 1.296 0.432-0.888-0.696-1.392-1.776-1.392-2.904 0-0.648 0.168-1.296 0.504-1.872 0.024-0.024 0.048-0.048 0.072-0.048s0.048 0 0.072 0.024c1.8 2.208 4.464 3.576 7.32 3.768-0.048-0.24-0.072-0.48-0.072-0.744 0-2.064 1.68-3.72 3.72-3.72 1.008 0 1.992 0.408 2.688 1.128 0.792-0.168 1.536-0.456 2.232-0.864 0.024-0.024 0.072-0.024 0.096 0s0.048 0.072 0.024 0.096c-0.24 0.744-0.696 1.368-1.32 1.848 0.576-0.096 1.152-0.264 1.68-0.504 0.024-0.024 0.072 0 0.096 0.024s0.024 0.072 0 0.096c-0.48 0.744-1.080 1.368-1.8 1.896z"></path></svg>',
		'et_icon-instagram'   => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M15.576 11.952c0 1.895-1.59 3.432-3.552 3.432s-3.552-1.537-3.552-3.432c0-1.895 1.59-3.432 3.552-3.432s3.552 1.537 3.552 3.432zM17.52 12.144c0 2.952-2.472 5.328-5.496 5.328s-5.496-2.376-5.496-5.328c0-0.528 0.072-1.032 0.216-1.512h-1.632v7.464c0 0.384 0.312 0.696 0.696 0.696h12.312c0.384 0 0.696-0.312 0.696-0.696v-7.464h-1.536c0.144 0.48 0.24 0.984 0.24 1.512zM16.032 8.616h1.992c0.432 0 0.792-0.36 0.792-0.792v-1.896c0-0.432-0.36-0.792-0.792-0.792h-1.992c-0.432 0-0.792 0.36-0.792 0.792v1.896c0 0.432 0.36 0.792 0.792 0.792zM12 0c-6.624 0-12 5.376-12 12s5.376 12 12 12 12-5.376 12-12-5.376-12-12-12zM18.576 20.832h-13.152c-1.248 0-2.28-0.936-2.28-2.28v-13.128c0-1.344 1.032-2.28 2.28-2.28h13.152c1.248 0 2.28 0.936 2.28 2.28v13.152c-0.024 1.344-1.032 2.256-2.28 2.256z"></path></svg>',
		'et_icon-youtube'     => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M6.312 12.888h0.936v5.136h0.912v-5.136h0.96v-0.84h-2.808zM13.92 13.512c-0.288 0-0.576 0.168-0.84 0.48v-1.968h-0.816v6h0.816v-0.432c0.264 0.336 0.552 0.504 0.84 0.504 0.312 0 0.528-0.168 0.648-0.504 0.048-0.192 0.072-0.48 0.072-0.888v-1.776c0-0.432-0.024-0.72-0.072-0.888-0.12-0.36-0.336-0.528-0.648-0.528zM13.824 16.752c0 0.408-0.12 0.6-0.36 0.6-0.144 0-0.264-0.072-0.408-0.192v-2.712c0.144-0.144 0.264-0.192 0.408-0.192 0.24 0 0.36 0.216 0.36 0.6v1.896zM10.752 16.992c-0.168 0.264-0.36 0.384-0.504 0.384-0.12 0-0.168-0.072-0.192-0.192 0-0.024 0-0.12 0-0.312v-3.312h-0.816v3.528c0 0.312 0.024 0.528 0.072 0.672 0.072 0.216 0.264 0.336 0.528 0.336 0.288 0 0.6-0.168 0.936-0.552v0.48h0.816v-4.464h-0.816v3.432zM11.448 9.456c0.264 0 0.384-0.216 0.384-0.624v-1.896c0-0.408-0.12-0.624-0.384-0.624s-0.384 0.216-0.384 0.624v1.896c0 0.408 0.12 0.624 0.384 0.624zM12 0c-6.624 0-12 5.376-12 12s5.376 12 12 12 12-5.376 12-12-5.376-12-12-12zM13.344 5.616h0.816v3.312c0 0.192 0 0.288 0 0.312 0.024 0.12 0.072 0.192 0.192 0.192 0.168 0 0.336-0.12 0.528-0.384v-3.432h0.816v4.512h-0.816v-0.504c-0.336 0.384-0.624 0.552-0.936 0.552-0.264 0-0.456-0.096-0.528-0.336-0.048-0.144-0.072-0.36-0.072-0.672v-3.552zM10.248 7.080c0-0.48 0.072-0.84 0.264-1.056 0.216-0.312 0.552-0.456 0.96-0.456s0.72 0.144 0.96 0.456c0.168 0.216 0.264 0.576 0.264 1.056v1.584c0 0.48-0.072 0.84-0.264 1.056-0.216 0.312-0.552 0.456-0.96 0.456s-0.72-0.144-0.96-0.456c-0.168-0.216-0.264-0.576-0.264-1.056v-1.584zM8.064 4.080l0.648 2.376 0.624-2.376h0.912l-1.080 3.6v2.448h-0.912v-2.448c-0.072-0.432-0.264-1.080-0.552-1.92-0.192-0.552-0.384-1.128-0.576-1.68-0.024 0 0.936 0 0.936 0zM18.456 18.432c-0.168 0.72-0.744 1.248-1.44 1.32-1.656 0.168-3.336 0.168-5.016 0.168s-3.36 0-5.016-0.192c-0.696-0.072-1.272-0.6-1.44-1.32-0.24-1.008-0.24-2.112-0.24-3.168s0-2.16 0.24-3.168c0.168-0.72 0.744-1.248 1.44-1.32 1.656-0.144 3.336-0.144 5.016-0.144s3.36 0 5.016 0.192c0.696 0.072 1.272 0.6 1.44 1.32 0.24 1.008 0.24 2.112 0.24 3.168s0 2.136-0.24 3.144zM16.488 13.512c-0.408 0-0.744 0.144-0.96 0.456-0.168 0.216-0.24 0.576-0.24 1.056v1.56c0 0.48 0.096 0.816 0.264 1.056 0.24 0.312 0.552 0.456 0.984 0.456s0.744-0.168 0.984-0.48c0.096-0.144 0.168-0.312 0.192-0.48 0-0.072 0.024-0.264 0.024-0.528v-0.12h-0.816c0 0.336 0 0.504-0.024 0.552-0.048 0.216-0.168 0.336-0.36 0.336-0.288 0-0.408-0.216-0.408-0.624v-0.792h1.608v-0.936c0-0.48-0.072-0.816-0.24-1.056-0.288-0.312-0.6-0.456-1.008-0.456zM16.896 15.288h-0.816v-0.408c0-0.408 0.144-0.624 0.408-0.624s0.408 0.216 0.408 0.624v0.408z"></path></svg>',
		'et_icon-linkedin'    => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0c-6.624 0-12 5.376-12 12s5.376 12 12 12 12-5.376 12-12-5.376-12-12-12zM7.512 20.136h-3.384v-10.872h3.384v10.872zM5.808 7.776c-1.080 0-1.968-0.888-1.968-1.968s0.864-1.944 1.968-1.944c1.080 0 1.944 0.888 1.944 1.944 0.024 1.104-0.864 1.968-1.944 1.968zM20.136 20.136h-3.36v-5.28c0-1.248-0.024-2.88-1.752-2.88-1.752 0-2.016 1.368-2.016 2.784v5.376h-3.36v-10.872h3.24v1.488h0.048c0.456-0.864 1.56-1.752 3.192-1.752 3.408 0 4.056 2.256 4.056 5.16-0.048 0-0.048 5.976-0.048 5.976z"></path></svg>',
		'et_icon-behance'     => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M9.648 9.504c0-1.128-0.768-1.128-0.768-1.128h-3.168v2.424h2.976c0.528 0 0.96-0.168 0.96-1.296zM8.88 12.48h-3.168v2.904h3.024c0.456-0.024 1.296-0.144 1.296-1.416 0-1.488-1.152-1.488-1.152-1.488zM16.992 10.8c-1.68 0-1.92 1.68-1.92 1.68h3.576c0.024 0 0.024-1.68-1.656-1.68zM12 0c-6.624 0-12 5.376-12 12s5.376 12 12 12 12-5.376 12-12-5.376-12-12-12zM14.616 7.080h4.488v1.344h-4.488v-1.344zM12.336 14.112c0 3.336-3.456 3.216-3.456 3.216h-5.664v-10.896h5.664c1.728 0 3.072 0.96 3.072 2.904s-1.656 2.064-1.656 2.064c2.208 0 2.040 2.712 2.040 2.712zM17.016 15.84c1.8 0 1.752-1.176 1.752-1.176h1.92c0 3.12-3.72 2.904-3.72 2.904-4.464 0-4.176-4.152-4.176-4.152s0-4.176 4.176-4.176c4.416 0 3.792 4.728 3.792 4.728h-5.664c0 1.992 1.92 1.872 1.92 1.872z"></path></svg>',
		'et_icon-houzz'       => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M7.608 12.12v-0.192l-0.168 0.096zM7.752 12.216l0.192 0.096v-0.624l-0.192 0.144zM12.048 0.048c-6.528 0-11.832 5.232-11.832 11.784s5.304 11.832 11.832 11.832 11.832-5.304 11.832-11.832c-0.024-6.552-5.328-11.784-11.832-11.784zM11.976 9.408v5.232l4.536-2.616v5.256l-4.536 2.616v-5.256l-4.536 2.592v-10.512l4.536-2.616v5.304zM11.64 9.6v4.8l0.192 0.096v-4.992zM11.256 9.768v4.44l0.192 0.096v-4.632zM10.92 9.96v4.008l0.192 0.096v-4.248zM10.584 10.2v3.624l0.192 0.096v-3.816zM10.2 10.392v3.192l0.192 0.096v-3.432zM9.864 10.584v2.808l0.192 0.096v-3zM9.528 10.776v2.376l0.192 0.096v-2.616zM9.144 11.016v2.016l0.192 0.096v-2.208zM8.808 11.208v1.584l0.192 0.096v-1.824zM8.472 11.4v1.2l0.192 0.096v-1.44zM8.088 11.592v0.768l0.192 0.096v-0.96zM16.512 12.024l-4.536-2.616 4.536-2.616v5.232z"></path></svg>',
		'et_icon-pinterest'   => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0c-6.624 0-12 5.376-12 12s5.376 12 12 12 12-5.376 12-12-5.376-12-12-12zM13.392 15.984c-1.104 0-2.16-0.6-2.52-1.272 0 0-0.6 2.376-0.72 2.832-0.456 1.608-1.752 3.24-1.848 3.36-0.072 0.096-0.216 0.072-0.24-0.048-0.024-0.216-0.36-2.232 0.024-3.912 0.192-0.84 1.32-5.592 1.32-5.592s-0.336-0.648-0.336-1.632c0-1.512 0.888-2.664 1.992-2.664 0.936 0 1.392 0.696 1.392 1.536 0 0.936-0.6 2.352-0.912 3.648-0.264 1.080 0.552 1.968 1.632 1.968 1.944 0 3.264-2.496 3.264-5.472 0-2.256-1.512-3.936-4.272-3.936-3.12 0-5.064 2.328-5.064 4.92 0 0.888 0.264 1.536 0.672 2.016 0.192 0.216 0.216 0.312 0.144 0.576-0.048 0.192-0.168 0.648-0.216 0.816-0.072 0.264-0.288 0.36-0.504 0.264-1.44-0.576-2.112-2.16-2.112-3.936 0-2.928 2.472-6.432 7.344-6.432 3.936 0 6.504 2.832 6.504 5.88 0 4.080-2.256 7.080-5.544 7.080z"></path></svg>',
		'et_icon-rss'         => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0c-6.624 0-12 5.376-12 12s5.376 12 12 12 12-5.376 12-12-5.376-12-12-12zM7.488 18c-0.84 0-1.488-0.672-1.488-1.488s0.672-1.488 1.488-1.488 1.488 0.672 1.488 1.488-0.648 1.488-1.488 1.488zM11.616 18c0-3.096-2.52-5.616-5.616-5.616v-2.256c4.344 0 7.872 3.528 7.872 7.872h-2.256zM16.128 18c0-2.712-1.056-5.256-2.976-7.152-1.92-1.92-4.464-2.976-7.152-2.976v-2.256c3.312 0 6.408 1.296 8.76 3.624 2.328 2.328 3.624 5.448 3.624 8.76h-2.256z"></path></svg>',
		'et_icon-skype'       => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0.048c-6.6 0-11.952 5.352-11.952 11.952s5.352 11.952 11.952 11.952 11.952-5.352 11.952-11.952c0-6.6-5.352-11.952-11.952-11.952zM15.24 19.056c-0.768 0-1.464-0.216-2.064-0.6-0.384 0.072-0.792 0.12-1.2 0.12-3.624 0-6.576-2.928-6.576-6.552 0-0.36 0.024-0.696 0.072-1.032-0.408-0.624-0.624-1.344-0.624-2.136 0-2.16 1.752-3.936 3.936-3.936 0.792 0 1.536 0.24 2.136 0.648 0.336-0.048 0.696-0.096 1.056-0.096 3.624 0 6.576 2.928 6.576 6.552 0 0.312-0.024 0.6-0.072 0.888 0.432 0.624 0.672 1.392 0.672 2.208 0.024 2.184-1.752 3.936-3.912 3.936zM11.136 10.776c-1.896-0.456-0.864-2.088 0.672-2.064 1.488 0.024 2.256 1.608 2.928 1.512 0.672-0.072 1.248-1.104 0.192-2.016-0.912-0.792-2.088-1.224-3.888-1.056-1.416 0.12-2.736 1.032-2.904 2.808s1.92 2.664 3.576 2.904c1.152 0.168 2.736 0.744 1.8 1.824-0.864 1.008-2.52 0.384-2.952 0.12s-0.936-1.248-1.728-1.2c-0.816 0.048-1.224 1.128-0.216 2.064 0.888 0.84 1.872 1.296 3.96 1.2 2.088-0.12 3.96-1.944 3.24-3.696-0.744-1.752-2.784-1.944-4.68-2.4z"></path></svg>',
		'et_icon-snapchat'    => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0.048c-6.6 0-11.952 5.352-11.952 11.952s5.352 11.952 11.952 11.952 11.952-5.352 11.952-11.952-5.352-11.952-11.952-11.952zM17.112 16.464c-0.048 0.072-0.096 0.408-0.168 0.648-0.096 0.288-0.36 0.264-0.648 0.192-0.432-0.096-0.816-0.12-1.272-0.024-0.792 0.12-1.584 1.296-2.952 1.296-1.464 0-2.232-1.152-3.048-1.296-0.84-0.144-1.296 0.072-1.584 0.072-0.216 0-0.312-0.144-0.336-0.24-0.072-0.24-0.12-0.576-0.168-0.648-0.552-0.096-1.824-0.312-1.872-0.864 0-0.144 0.096-0.288 0.24-0.312 1.872-0.312 3.048-2.4 2.856-2.856-0.144-0.312-0.744-0.432-0.984-0.528-0.648-0.264-0.744-0.552-0.696-0.744 0.048-0.288 0.384-0.456 0.672-0.456 0.264 0 0.768 0.36 1.128 0.168-0.048-0.984-0.192-2.376 0.144-3.168 0.672-1.488 2.112-2.232 3.576-2.232s2.928 0.744 3.6 2.232c0.336 0.792 0.216 2.184 0.144 3.168 0.36 0.192 0.792-0.168 1.104-0.168s0.72 0.192 0.72 0.552c0 0.264-0.24 0.504-0.696 0.672-0.264 0.096-0.84 0.216-0.984 0.528-0.192 0.456 1.032 2.568 2.856 2.856 0.144 0.024 0.24 0.144 0.24 0.312-0.048 0.528-1.32 0.744-1.872 0.84z"></path></svg>',
		'et_icon-tripadvisor' => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M16.512 11.304c-0.816 0-1.464 0.648-1.464 1.464 0 0.792 0.648 1.464 1.464 1.464 0.792 0 1.464-0.648 1.464-1.464-0.024-0.792-0.672-1.464-1.464-1.464zM16.512 13.512c-0.408 0-0.744-0.336-0.744-0.744 0-0.432 0.312-0.744 0.744-0.744 0.408 0 0.744 0.336 0.744 0.744-0.024 0.408-0.36 0.744-0.744 0.744zM7.488 9.216c-1.944-0.024-3.624 1.608-3.6 3.672 0.024 1.92 1.608 3.552 3.648 3.528 1.968-0.024 3.576-1.632 3.576-3.576 0-2.016-1.608-3.624-3.624-3.624zM7.56 15c-1.296 0.048-2.352-0.984-2.352-2.232 0-1.272 1.056-2.256 2.232-2.232 1.224 0 2.232 0.984 2.232 2.232s-0.984 2.184-2.112 2.232zM12 0c-6.624 0-12 5.376-12 12s5.376 12 12 12 12-5.376 12-12-5.376-12-12-12zM18.888 16.656c-0.744 0.456-1.536 0.696-2.4 0.696-0.36 0-0.72-0.048-1.080-0.144-0.864-0.216-1.608-0.648-2.208-1.32-0.072-0.096-0.168-0.168-0.24-0.264-0.312 0.48-0.648 0.96-0.96 1.44-0.336-0.48-0.648-0.96-0.96-1.416-0.024 0-0.024 0.024-0.024 0.024s-0.024 0.024-0.024 0.024c-0.744 0.864-1.68 1.416-2.808 1.584-0.624 0.096-1.248 0.072-1.872-0.096-0.864-0.24-1.608-0.696-2.208-1.368-0.576-0.648-0.936-1.416-1.080-2.304-0.144-0.816 0.024-1.608 0.072-1.776 0.144-0.552 0.384-1.056 0.696-1.536 0.048-0.048 0.048-0.12 0.048-0.144-0.144-0.48-0.36-0.936-0.624-1.368-0.072-0.12-0.144-0.216-0.216-0.312 0-0.024 0-0.024 0-0.048 0.024 0 0.024 0 0.048 0 0.912 0 1.824 0 2.712 0 0.048 0 0.072-0.024 0.12-0.048 0.648-0.408 1.32-0.744 2.040-0.984 0.504-0.192 1.032-0.312 1.584-0.432 0.528-0.096 1.032-0.168 1.56-0.216 1.296-0.096 2.304 0.048 3 0.144 0.504 0.072 1.008 0.192 1.488 0.336 0.84 0.264 1.656 0.624 2.4 1.104 0.048 0.024 0.12 0.048 0.192 0.048 0.888 0 1.776 0 2.664 0 0.072 0 0.144 0 0.216 0 0 0.024 0 0.024 0 0.024-0.048 0.072-0.072 0.12-0.12 0.192-0.312 0.456-0.552 0.936-0.72 1.488-0.024 0.048-0.024 0.096 0.024 0.168 0.792 1.128 1.032 2.376 0.72 3.72-0.336 1.224-1.008 2.136-2.040 2.784zM7.416 11.304c-0.792 0-1.44 0.672-1.44 1.464s0.672 1.464 1.464 1.464c0.792 0 1.464-0.672 1.464-1.464 0-0.816-0.672-1.464-1.488-1.464zM7.44 13.512c-0.432 0-0.744-0.336-0.744-0.744s0.336-0.744 0.744-0.744c0.408 0 0.744 0.336 0.744 0.744s-0.336 0.744-0.744 0.744zM16.416 9.216c-1.968 0.048-3.504 1.632-3.528 3.6 0 1.992 1.608 3.624 3.6 3.624s3.6-1.584 3.6-3.6c0.024-2.088-1.68-3.648-3.672-3.624zM16.584 15c-1.296 0.048-2.328-0.984-2.328-2.232 0-1.272 1.032-2.256 2.232-2.232 1.224 0 2.232 0.984 2.232 2.232 0 1.224-0.984 2.184-2.136 2.232zM13.44 9.48c0.792-0.72 1.752-1.104 2.832-1.2-1.272-0.576-2.616-0.816-4.008-0.84-1.584-0.024-3.12 0.192-4.584 0.816 1.104 0.072 2.064 0.456 2.88 1.176 0.816 0.744 1.296 1.656 1.464 2.736 0.144-1.032 0.624-1.944 1.416-2.688z"></path></svg>',
		'et_icon-tumblr'      => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0c-6.624 0-12 5.376-12 12s5.376 12 12 12 12-5.376 12-12-5.376-12-12-12zM9.072 15.744v-5.040c-0.72 0-1.248 0-1.872 0 0-0.816 0-1.536 0-2.352 1.416-0.408 2.64-1.92 3.096-3.504 0.168-0.696 0.192-1.176 0.192-1.176s2.184 0 2.664 0c0 1.44 0 2.88 0 4.296 1.056 0 2.064 0 3.12 0v2.712c-1.008 0-2.016 0-3.144 0 0 0.552 0 1.104 0 1.56 0 1.056 0 2.112 0 3.144 0 2.784 2.688 1.632 2.928 1.584l0.768 2.544c-0.672 0.744-7.752 2.448-7.752-3.768z"></path></svg>',
		'et_icon-vimeo'       => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0.168c-6.528 0-11.832 5.304-11.832 11.832s5.304 11.832 11.832 11.832 11.832-5.304 11.832-11.832-5.304-11.832-11.832-11.832zM18.96 10.296c-0.792 4.416-5.184 8.16-6.504 9.024s-2.52-0.336-2.952-1.248c-0.504-1.032-1.992-6.624-2.4-7.104-0.384-0.456-1.56 0.456-1.56 0.456l-0.576-0.744c0 0 2.4-2.856 4.2-3.216 1.92-0.384 1.92 2.952 2.4 4.824 0.456 1.8 0.744 2.832 1.152 2.832 0.384 0 1.152-1.008 1.968-2.544s-0.024-2.88-1.632-1.92c0.624-3.864 6.696-4.776 5.904-0.36z"></path></svg>',
		'et_icon-vk'          => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0c-6.624 0-12 5.376-12 12s5.376 12 12 12 12-5.376 12-12-5.376-12-12-12zM18.096 13.296c0.552 0.552 1.152 1.056 1.656 1.656 0.216 0.264 0.432 0.552 0.6 0.864 0.216 0.432 0.024 0.936-0.384 0.96h-2.448c-0.624 0.048-1.152-0.192-1.56-0.648-0.336-0.336-0.648-0.72-0.984-1.080-0.144-0.144-0.264-0.288-0.432-0.384-0.336-0.216-0.624-0.144-0.816 0.192-0.192 0.36-0.24 0.744-0.264 1.152-0.024 0.576-0.192 0.72-0.792 0.768-1.248 0.048-2.424-0.12-3.528-0.768-0.96-0.552-1.704-1.344-2.376-2.208-1.272-1.728-2.232-3.6-3.12-5.544-0.192-0.432-0.048-0.672 0.432-0.672 0.792-0.024 1.608-0.024 2.4 0 0.336 0 0.552 0.192 0.672 0.504 0.432 1.056 0.96 2.088 1.632 3.024 0.168 0.24 0.36 0.504 0.624 0.672 0.288 0.192 0.504 0.12 0.648-0.192 0.096-0.192 0.12-0.408 0.144-0.624 0.072-0.744 0.072-1.488-0.048-2.232-0.072-0.456-0.336-0.768-0.792-0.84-0.24-0.048-0.192-0.12-0.096-0.264 0.192-0.24 0.384-0.384 0.744-0.384h2.784c0.432 0.096 0.528 0.288 0.6 0.72v3.096c0 0.168 0.096 0.672 0.384 0.792 0.24 0.072 0.408-0.12 0.552-0.264 0.672-0.696 1.152-1.536 1.56-2.4 0.192-0.384 0.36-0.768 0.504-1.176 0.12-0.288 0.288-0.432 0.624-0.432h2.664c0.072 0 0.168 0 0.24 0.024 0.456 0.072 0.576 0.264 0.432 0.72-0.216 0.696-0.648 1.272-1.056 1.848-0.456 0.624-0.912 1.224-1.368 1.824-0.384 0.528-0.336 0.816 0.168 1.296z"></path></svg>',
		'et_icon-whatsapp'    => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M12 0.024v0c-6.6 0-11.976 5.376-11.976 11.976 0 2.616 0.84 5.040 2.28 7.008l-1.488 4.44 4.608-1.464c1.896 1.248 4.152 1.968 6.576 1.968 6.6 0 11.952-5.376 11.952-11.976s-5.352-11.952-11.952-11.952zM18.96 16.92c-0.288 0.816-1.44 1.488-2.352 1.68-0.624 0.144-1.44 0.24-4.2-0.912-3.528-1.464-5.784-5.040-5.952-5.256-0.168-0.24-1.416-1.896-1.416-3.6s0.864-2.544 1.224-2.904c0.288-0.288 0.768-0.432 1.224-0.432 0.144 0 0.288 0 0.408 0.024 0.36 0.024 0.528 0.024 0.768 0.6 0.288 0.696 0.984 2.424 1.080 2.592s0.168 0.408 0.048 0.648c-0.12 0.24-0.216 0.336-0.384 0.552-0.168 0.192-0.336 0.36-0.528 0.576-0.168 0.192-0.336 0.384-0.144 0.744 0.192 0.336 0.912 1.488 1.944 2.424 1.344 1.2 2.424 1.56 2.808 1.728 0.288 0.12 0.624 0.096 0.84-0.144 0.264-0.288 0.6-0.768 0.936-1.248 0.24-0.336 0.552-0.384 0.864-0.264s2.040 0.96 2.376 1.128c0.36 0.168 0.576 0.264 0.672 0.408 0.072 0.144 0.072 0.84-0.216 1.656z"></path></svg>',
		'et_icon-etsy'        => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" x="0px" y="0px" viewBox="0 0 24 24" style="enable-background:new 0 0 24 24;" xml:space="preserve"><g><path d="M12,0C5.3725629,0,0,5.372808,0,12s5.3725629,12,12,12s12-5.3728085,12-12S18.6274357,0,12,0z M19.3298817,16.7314987c-0.1365108,1.1289215-0.2781792,2.2568607-0.404871,3.3870087c-0.0466499,0.4205818-0.0306892,0.418129-0.4618301,0.4132156c-3.2912521-0.0410023-6.5822601-0.0942802-9.8735142-0.1126938c-1.1792526-0.006876-2.3587518,0.0709553-3.5384955,0.1080303c-0.1561532,0.0051575-0.3120613,0.0009823-0.4976778,0.0009823c0-0.3280201,0-0.645483,0-1.0137691c0.4205828-0.0829868,0.8664551-0.1654854,1.3096266-0.260994c0.182179-0.0392857,0.362885-0.0962448,0.5354881-0.1654835c0.2605019-0.1048393,0.4240203-0.2985592,0.4615855-0.5843487c0.0174322-0.1343002,0.0439491-0.2690945,0.0451765-0.4036407c0.0225883-2.4557333,0.0535245-4.9112215,0.056962-7.3667107C6.9645414,9.207653,6.9255033,7.6824565,6.9004593,6.157505C6.8864646,5.2939959,6.6578813,5.0253925,5.8159785,4.864574c-0.357729-0.0680103-0.7193861-0.1220255-1.073432-0.2045221C4.657104,4.6396732,4.5355692,4.5358167,4.5286946,4.4611773C4.50316,4.1829987,4.5186281,3.9016275,4.5186281,3.597914c4.7209415,0.0785677,9.4151201,0.2774425,14.1534929-0.1316011c-0.0991917,1.6025372-0.1986275,3.2080207-0.2997856,4.8422303c-0.2870159,0-0.5497284,0.0228338-0.8045826-0.0120306c-0.090107-0.0127668-0.2032948-0.1522245-0.2344761-0.2553453c-0.1443672-0.4782815-0.2511711-0.9681029-0.3960304-1.4466295c-0.0849514-0.2779336-0.1993656-0.5502195-0.3304749-0.8099847c-0.2963486-0.5880308-0.7412376-0.9037747-1.4456482-0.8917441c-1.6931353,0.0297084-3.3867617,0.0090847-5.0798979,0.0100665C9.6505747,4.903367,9.6378088,4.9176068,9.6373177,5.3394179C9.6348629,7.2417397,9.6333895,9.1443081,9.631916,11.0463848c-0.0004902,0.103857,0,0.2077141,0,0.3383322c0.7486038,0,1.4564505,0.0117855,2.163806-0.0044203c0.4583941-0.010066,0.9160509-0.0552425,1.3737087-0.0930538c0.6258411-0.0518055,0.8482866-0.2344761,1.0056677-0.8384657c0.1178513-0.4532375,0.2234268-0.909668,0.3255653-1.3668337c0.040266-0.1802158,0.1222706-0.2632017,0.3199186-0.2492075c0.2489614,0.0176773,0.5001326,0.0044203,0.7854319,0.0044203c0,0.1662188,0.0014734,0.3152533,0,0.465023c-0.0152225,1.7852068-0.0346184,3.5704145-0.040266,5.3556213c-0.0009823,0.237422-0.0559797,0.3319492-0.3108339,0.3331757c-0.7500763,0.0054016-0.7495861,0.0154686-0.926362-0.7169304c-0.0638361-0.2632017-0.1279182-0.5268946-0.1971569-0.7883778c-0.1588535-0.6027622-0.608655-0.8247166-1.1743431-0.8433762c-1.0643473-0.0358467-2.130168-0.0461588-3.1954985-0.0665369c-0.0289717-0.0004911-0.0581894,0.0154676-0.1153965,0.0306902c-0.0051565,0.1180973-0.0154676,0.2403679-0.0157137,0.3623943c-0.0024548,1.5890331-0.0039282,3.1775742-0.0044193,4.7663631c-0.0007362,0.9872532,0.371233,1.4662704,1.3616781,1.4942608c1.5232325,0.0437031,3.050148,0.0120316,4.5738726-0.0346203c0.9216976-0.0277424,1.5529404-0.5676498,1.9482346-1.3700256c0.3221264-0.6545677,0.6167564-1.3238659,0.8890438-2.0000391c0.120306-0.2997856,0.2771969-0.4387522,0.6017799-0.3889103c0.1406841,0.0220966,0.2882462,0.0036821,0.4861374,0.0036821C19.4310379,15.896471,19.3802147,16.3138618,19.3298817,16.7314987z"/></g></svg>',
		'et_icon-tik-tok'     => '<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" x="0px" y="0px" viewBox="0 0 24 24" style="enable-background:new 0 0 24 24;" xml:space="preserve"><path d="M12,0C5.3736091,0,0,5.3736095,0,12s5.3736095,12,12,12s12-5.3736095,12-12S18.6263905,0,12,0z M18.0201569,9.1815472v1.6248274c-0.7661724,0.0002813-1.5105953-0.1498594-2.2126884-0.446063c-0.4514542-0.1905928-0.8720627-0.4361706-1.2567663-0.7329369l0.0115309,5.0012341c-0.0048275,1.1261721-0.4503746,2.1842804-1.2567654,2.9812984c-0.65625,0.6487484-1.487813,1.0612965-2.3891249,1.1948433c-0.2117815,0.0313587-0.4273129,0.0474377-0.6452818,0.0474377c-0.9648285,0-1.8808117-0.3125629-2.6301098-0.8892193c-0.1409998-0.1085644-0.2758589-0.2262669-0.4042497-0.3530636c-0.8739371-0.8637657-1.3245935-2.0344219-1.248703-3.2659693c0.0578904-0.9374533,0.4332185-1.8315001,1.0589061-2.5322342c0.8278131-0.9272814,1.9859066-1.441968,3.2241564-1.441968c0.217968,0,0.4335003,0.0163593,0.6452818,0.047718v0.60075v1.6711874c-0.2008123-0.0662336-0.4152651-0.1026564-0.6385784-0.1026564c-1.1312819,0-2.0465155,0.9229689-2.0295935,2.0550938c0.0107346,0.7243595,0.4064054,1.3575478,0.9899998,1.7065792c0.2742653,0.1640625,0.5897808,0.2656879,0.9264841,0.2841568c0.2638121,0.0144844,0.5171251-0.0222664,0.751687-0.0997028c0.8082657-0.2670021,1.3913441-1.0261879,1.3913441-1.9215946l0.0026722-3.3490772V5.1478128h2.2376251c0.0021553,0.2217188,0.0246563,0.4380469,0.0664682,0.6476717c0.168891,0.8484845,0.6471567,1.58461,1.3127813,2.0864534c0.5804062,0.4377661,1.3031254,0.6972656,2.0864544,0.6972656c0.000515,0,0.0069847,0,0.006422-0.0005159v0.6028595H18.0201569z"/></svg>'
	)
);

$et_cart_icons = array(
	'light' => array(
		'type1' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M20.232 5.352c-0.024-0.528-0.456-0.912-0.936-0.912h-2.736c-0.12-2.448-2.112-4.392-4.56-4.392s-4.464 1.944-4.56 4.392h-2.712c-0.528 0-0.936 0.432-0.936 0.936l-0.648 16.464c-0.024 0.552 0.168 1.104 0.552 1.512s0.888 0.624 1.464 0.624h13.68c0.552 0 1.056-0.216 1.464-0.624 0.36-0.408 0.552-0.936 0.552-1.488l-0.624-16.512zM12 1.224c1.8 0 3.288 1.416 3.408 3.216l-6.816-0.024c0.12-1.776 1.608-3.192 3.408-3.192zM7.44 5.616v1.968c0 0.336 0.264 0.6 0.6 0.6s0.6-0.264 0.6-0.6v-1.968h6.792v1.968c0 0.336 0.264 0.6 0.6 0.6s0.6-0.264 0.6-0.6v-1.968h2.472l0.624 16.224c-0.024 0.24-0.12 0.48-0.288 0.648s-0.384 0.264-0.6 0.264h-13.68c-0.24 0-0.456-0.096-0.624-0.264s-0.24-0.384-0.216-0.624l0.624-16.248h2.496z"></path></svg>',
		'type2' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.928 9.144c0.024-0.384-0.12-0.768-0.408-1.056s-0.672-0.456-1.104-0.456h-4.368l-5.52-7.368c-0.096-0.144-0.288-0.24-0.48-0.24s-0.36 0.096-0.456 0.24l-5.52 7.368h-4.464c-0.84 0-1.512 0.672-1.512 1.512v1.896c0 0.84 0.672 1.512 1.512 1.512h0.456l1.536 9.336c0.192 1.2 1.2 2.064 2.424 2.064h11.976c1.2 0 2.232-0.864 2.424-2.064l1.536-9.336h0.456c0.84 0 1.512-0.672 1.512-1.512v-1.896zM1.224 9.144c0-0.192 0.168-0.36 0.384-0.36h3.6l-0.192 0.264c-0.024 0-0.048 0-0.072 0-0.576 0-1.056 0.48-1.056 1.056s0.48 1.056 1.056 1.056c0.576 0 1.056-0.48 1.056-1.056 0-0.12-0.024-0.264-0.072-0.384l0.72-0.96h10.824l0.72 0.96c-0.048 0.096-0.072 0.216-0.072 0.384 0 0.576 0.48 1.056 1.056 1.056s1.056-0.48 1.056-1.056c0-0.576-0.48-1.056-1.056-1.056-0.024 0-0.048 0-0.072 0l-0.192-0.264h3.6c0.192 0 0.384 0.192 0.384 0.384v1.872c0 0.192-0.192 0.384-0.384 0.384h-20.904c-0.192 0-0.384-0.192-0.384-0.384v-1.896zM7.512 7.632l4.536-6.072 4.56 6.072h-9.096zM3.24 12.576h17.664l-1.536 9.144c-0.12 0.648-0.672 1.104-1.296 1.104h-12c-0.648 0-1.2-0.48-1.296-1.104l-1.536-9.144zM12.048 0.312v0 0 0zM15.864 22.080c0.312 0 0.576-0.264 0.576-0.576v-7.608c0-0.312-0.264-0.576-0.576-0.576s-0.576 0.264-0.576 0.576v7.608c0 0.312 0.264 0.576 0.576 0.576zM8.28 22.080c0.312 0 0.576-0.264 0.576-0.576v-7.608c0-0.312-0.264-0.576-0.576-0.576s-0.576 0.264-0.576 0.576v7.608c0 0.312 0.264 0.576 0.576 0.576zM12.072 22.080c0.312 0 0.576-0.264 0.576-0.576v-7.608c0-0.312-0.264-0.576-0.576-0.576s-0.576 0.264-0.576 0.576v7.608c0 0.312 0.264 0.576 0.576 0.576z"></path></svg>',
		'type3' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.76 4.248c-0.096-0.096-0.24-0.24-0.504-0.24h-18.48l-0.48-2.4c-0.024-0.288-0.384-0.528-0.624-0.528h-2.952c-0.384 0-0.624 0.264-0.624 0.624s0.264 0.648 0.624 0.648h2.424l2.328 11.832c0.312 1.608 1.848 2.856 3.48 2.856h11.28c0.384 0 0.624-0.264 0.624-0.624s-0.264-0.624-0.624-0.624h-11.16c-0.696 0-1.344-0.312-1.704-0.816l14.064-1.92c0.264 0 0.528-0.24 0.528-0.528l1.968-7.824v-0.024c-0.024-0.048-0.024-0.288-0.168-0.432zM22.392 5.184l-1.608 6.696-14.064 1.824-1.704-8.52h17.376zM8.568 17.736c-1.464 0-2.592 1.128-2.592 2.592s1.128 2.592 2.592 2.592c1.464 0 2.592-1.128 2.592-2.592s-1.128-2.592-2.592-2.592zM9.888 20.328c0 0.696-0.624 1.32-1.32 1.32s-1.32-0.624-1.32-1.32 0.624-1.32 1.32-1.32 1.32 0.624 1.32 1.32zM18.36 17.736c-1.464 0-2.592 1.128-2.592 2.592s1.128 2.592 2.592 2.592c1.464 0 2.592-1.128 2.592-2.592s-1.128-2.592-2.592-2.592zM19.704 20.328c0 0.696-0.624 1.32-1.32 1.32s-1.344-0.6-1.344-1.32 0.624-1.32 1.32-1.32 1.344 0.624 1.344 1.32z"></path></svg>',
		'type4' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M0.096 4.656v0.024l1.968 7.824c0 0.264 0.264 0.528 0.528 0.528l14.064 1.92c-0.384 0.504-1.032 0.816-1.704 0.816h-11.184c-0.384 0-0.624 0.264-0.624 0.624s0.264 0.624 0.624 0.624h11.28c1.656 0 3.168-1.248 3.48-2.856l2.328-11.832h2.424c0.384 0 0.624-0.264 0.624-0.624s-0.264-0.624-0.624-0.624h-2.952c-0.24 0-0.624 0.24-0.624 0.528l-0.456 2.424h-18.528c-0.264 0-0.384 0.144-0.504 0.24-0.12 0.12-0.12 0.36-0.12 0.384zM18.984 5.184l-1.704 8.52-14.088-1.824-1.584-6.696h17.376zM12.84 20.328c0 1.464 1.128 2.592 2.592 2.592s2.592-1.128 2.592-2.592c0-1.464-1.128-2.592-2.592-2.592s-2.592 1.128-2.592 2.592zM15.432 19.008c0.696 0 1.32 0.624 1.32 1.32s-0.624 1.32-1.32 1.32-1.32-0.624-1.32-1.32 0.6-1.32 1.32-1.32zM3.024 20.328c0 1.464 1.128 2.592 2.592 2.592s2.592-1.128 2.592-2.592c0-1.464-1.128-2.592-2.592-2.592-1.44 0-2.592 1.128-2.592 2.592zM5.64 19.008c0.696 0 1.32 0.624 1.32 1.32s-0.624 1.32-1.32 1.32-1.32-0.624-1.32-1.32 0.6-1.32 1.32-1.32z"></path></svg>',
		'none'  => ''
	),
	'bold'  => array(
		'type1' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M20.304 5.544v0c-0.024-0.696-0.576-1.224-1.272-1.224h-2.304c-0.288-2.424-2.304-4.248-4.728-4.248-2.448 0-4.464 1.824-4.728 4.248h-2.28c-0.696 0-1.272 0.576-1.272 1.248l-0.624 15.936c-0.024 0.648 0.192 1.272 0.624 1.728 0.432 0.48 1.008 0.72 1.68 0.72h13.176c0.624 0 1.2-0.24 1.68-0.72 0.408-0.456 0.624-1.056 0.624-1.704l-0.576-15.984zM9.12 4.296c0.288-1.344 1.464-2.376 2.88-2.376s2.592 1.032 2.88 2.4l-5.76-0.024zM8.184 8.664c0.528 0 0.936-0.408 0.936-0.936v-1.536h5.832v1.536c0 0.528 0.408 0.936 0.936 0.936s0.936-0.408 0.936-0.936v-1.536h1.68l0.576 15.336c-0.024 0.144-0.072 0.288-0.168 0.384s-0.216 0.144-0.312 0.144h-13.2c-0.12 0-0.24-0.048-0.336-0.144-0.072-0.072-0.12-0.192-0.096-0.336l0.6-15.384h1.704v1.536c-0.024 0.528 0.384 0.936 0.912 0.936z"></path></svg>',
		'type2' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.4 8.016c-0.336-0.336-0.768-0.504-1.248-0.504h-4.128l-5.304-7.104c-0.144-0.216-0.408-0.336-0.672-0.336s-0.504 0.12-0.624 0.336l-5.328 7.104h-4.248c-0.936 0-1.704 0.768-1.704 1.704v1.848c0 0.936 0.768 1.704 1.704 1.704h0.24l1.464 8.928c0.216 1.272 1.296 2.208 2.592 2.208h11.688c1.296 0 2.4-0.936 2.592-2.208l1.464-8.928h0.24c0.936 0 1.704-0.768 1.704-1.704v-1.848c0.072-0.432-0.096-0.888-0.432-1.2zM20.424 12.792l-1.464 8.64c-0.096 0.504-0.528 0.888-1.032 0.888h-11.712c-0.504 0-0.96-0.384-1.032-0.888l-1.464-8.664h16.704zM8.088 7.512l3.96-5.304 3.984 5.304h-7.944zM3.84 10.152c0 0.432 0.24 0.816 0.576 1.056h-2.568c-0.048 0-0.144-0.072-0.144-0.144v-1.848c0-0.048 0.048-0.12 0.144-0.12h2.568c-0.336 0.216-0.576 0.624-0.576 1.056zM6.336 9.816l0.552-0.744h10.32l0.552 0.744c-0.024 0.096-0.048 0.216-0.048 0.336 0 0.432 0.216 0.816 0.576 1.056h-12.48c0.336-0.24 0.576-0.624 0.576-1.056 0-0.12-0.024-0.216-0.048-0.336zM20.28 10.152c0-0.432-0.24-0.816-0.576-1.056h2.568c0.048 0 0.144 0.072 0.144 0.144v1.824c0 0.048-0.072 0.144-0.144 0.144h-2.568c0.336-0.24 0.576-0.624 0.576-1.056zM15.768 22.080c0.432 0 0.792-0.36 0.792-0.792v-7.44c0-0.432-0.36-0.792-0.792-0.792s-0.792 0.36-0.792 0.792v7.416c0 0.456 0.36 0.816 0.792 0.816zM8.376 22.080c0.432 0 0.792-0.36 0.792-0.792v-7.44c0-0.432-0.36-0.792-0.792-0.792s-0.792 0.36-0.792 0.792v7.416c0 0.456 0.36 0.816 0.792 0.816zM12.072 22.080c0.432 0 0.792-0.36 0.792-0.792v-7.44c0-0.432-0.36-0.792-0.792-0.792s-0.792 0.36-0.792 0.792v7.416c0 0.456 0.36 0.816 0.792 0.816z"></path></svg>',
		'type3' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M0.048 1.872c0 0.504 0.36 0.84 0.84 0.84h2.184l2.28 11.448c0.336 1.704 1.896 3 3.648 3h11.088c0.48 0 0.84-0.36 0.84-0.84 0-0.504-0.36-0.84-0.84-0.84h-10.992c-0.432 0-0.84-0.144-1.176-0.384l13.344-1.824c0.36 0 0.72-0.36 0.744-0.72l1.944-7.704v-0.048c0-0.096-0.024-0.384-0.192-0.552l-0.072-0.048c-0.12-0.096-0.288-0.24-0.6-0.24h-18.024l-0.408-2.16c-0.024-0.432-0.504-0.744-0.84-0.744h-2.904c-0.48-0.024-0.864 0.336-0.864 0.816zM21.912 5.544l-1.44 6.12-13.464 1.752-1.584-7.872h16.488zM5.832 20.184c0 1.56 1.224 2.784 2.784 2.784s2.784-1.224 2.784-2.784-1.224-2.784-2.784-2.784-2.784 1.224-2.784 2.784zM8.616 19.128c0.576 0 1.056 0.504 1.056 1.056s-0.504 1.056-1.056 1.056c-0.552 0-1.056-0.504-1.056-1.056s0.504-1.056 1.056-1.056zM15.48 20.184c0 1.56 1.224 2.784 2.784 2.784s2.784-1.224 2.784-2.784-1.224-2.784-2.784-2.784c-1.56 0-2.784 1.224-2.784 2.784zM18.24 19.128c0.576 0 1.056 0.504 1.056 1.056s-0.504 1.056-1.056 1.056c-0.552 0-1.056-0.504-1.056-1.056s0.504-1.056 1.056-1.056z"></path></svg>',
		'type4' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.088 1.032h-2.904c-0.336 0-0.84 0.312-0.84 0.744l-0.408 2.16h-18.024c-0.312 0-0.48 0.144-0.6 0.24l-0.072 0.048c-0.168 0.168-0.192 0.432-0.192 0.552v0.048l1.944 7.704c0.024 0.36 0.36 0.72 0.744 0.72l13.344 1.824c-0.336 0.24-0.744 0.384-1.176 0.384h-10.992c-0.504 0-0.84 0.36-0.84 0.84s0.36 0.84 0.84 0.84h11.088c1.752 0 3.312-1.296 3.648-3l2.256-11.448h2.184c0.504 0 0.84-0.36 0.84-0.84 0.024-0.456-0.36-0.816-0.84-0.816zM18.576 5.544l-1.584 7.872-13.464-1.752-1.44-6.12h16.488zM15.384 17.4c-1.56 0-2.784 1.224-2.784 2.784s1.224 2.784 2.784 2.784 2.784-1.224 2.784-2.784-1.224-2.784-2.784-2.784zM16.44 20.184c0 0.552-0.504 1.056-1.056 1.056s-1.056-0.504-1.056-1.056c0-0.576 0.504-1.056 1.056-1.056s1.056 0.504 1.056 1.056zM5.736 17.4c-1.56 0-2.784 1.224-2.784 2.784s1.224 2.784 2.784 2.784 2.784-1.224 2.784-2.784-1.224-2.784-2.784-2.784zM6.816 20.184c0 0.552-0.504 1.056-1.056 1.056s-1.056-0.504-1.056-1.056c0-0.576 0.504-1.056 1.056-1.056s1.056 0.504 1.056 1.056z"></path></svg>',
		'none'  => ''
	),
);

$et_wishlist_icons = array(
	'light' => array(
		'type1' => '<svg version="1.1" width="1em" height="1em" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" xml:space="preserve"><path d="M99.5,31.5C98.4,17.2,86.3,5.7,71.9,5.3C63.8,5,55.6,8.5,50,14.5C44.3,8.4,36.4,5,28.1,5.3C13.7,5.7,1.6,17.2,0.5,31.5
                    c-0.1,1.2-0.1,2.5-0.1,3.7c0.2,5.1,2.4,10.2,6.1,14.3l39.2,43.4c1.1,1.2,2.7,1.9,4.3,1.9c1.6,0,3.2-0.7,4.4-1.9l39.1-43.4
                    c3.7-4.1,5.8-9.1,6.1-14.3C99.6,34,99.6,32.7,99.5,31.5z M49.6,89.2L10.5,45.8c-2.8-3.1-4.5-7-4.7-10.9c0-1,0-2,0.1-3
                    C6.8,20.4,16.6,11,28.2,10.7c0.2,0,0.5,0,0.7,0c7.4,0,14.5,3.6,18.8,9.7c0.5,0.7,1.3,1.1,2.2,1.1s1.7-0.4,2.2-1.1
                    c4.5-6.3,11.8-9.9,19.6-9.7c11.6,0.4,21.4,9.7,22.4,21.2c0.1,1,0.1,2,0.1,3v0c-0.2,3.9-1.8,7.8-4.7,10.9L50.4,89.2
                    C50.2,89.4,49.7,89.3,49.6,89.2z"/></svg>',
		'type2' => '<svg version="1.1" width="1em" height="1em" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" xml:space="preserve"><path d="M99.4,38.4c-0.7-2.1-2.4-3.6-4.6-3.9l-27.5-4l-12.2-25c-1-2-2.9-3.2-5.1-3.2s-4.1,1.2-5.1,3.2l-12.3,25l-27.5,4
                    c-2.1,0.3-3.9,1.8-4.6,3.9s-0.1,4.4,1.5,6l19.8,19.3l-4.7,27.3c-0.3,1.7,0.2,3.4,1.3,4.7c1.7,2,4.6,2.6,6.9,1.4L50,84L74.7,97
                    c0.8,0.4,1.7,0.6,2.6,0.6c1.7,0,3.2-0.7,4.3-2c1.1-1.3,1.6-3,1.3-4.7l-4.7-27.4L98,44.2C99.6,42.7,100.1,40.5,99.4,38.4z M22.5,91.9
                    l5-28.8c0.2-0.9-0.1-1.8-0.8-2.4L5.9,40.4c0,0-0.1-0.1-0.1-0.3C5.8,40,5.9,40,5.9,40l28.9-4.2c0.9-0.1,1.7-0.7,2.1-1.5l13-26.5
                    c0-0.1,0.1-0.2,0.1-0.2s0.1,0.1,0.1,0.2l13,26.3c0.4,0.8,1.2,1.4,2.1,1.5l28.9,4.2c0,0,0.1,0,0.1,0.2c0.1,0.2,0,0.3-0.1,0.3
                    L73.3,60.7c-0.6,0.6-0.9,1.5-0.8,2.4l5,28.8c0,0.1,0,0.2-0.1,0.3l0,0L51.3,78.5c-0.8-0.4-1.8-0.4-2.6,0L22.6,92.1l0,0
                    C22.5,92,22.5,92,22.5,91.9z"/></svg>',
		'none'  => '',
	),
	'bold'  => array(
		'type1' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.928 7.656c-0.264-3.528-3.264-6.36-6.792-6.456-1.872-0.072-3.768 0.672-5.136 1.992-1.392-1.344-3.24-2.064-5.136-1.992-3.528 0.096-6.528 2.928-6.792 6.456-0.024 0.288-0.024 0.624-0.024 0.912 0.048 1.272 0.6 2.544 1.512 3.576l9.168 10.152c0.312 0.36 0.792 0.552 1.272 0.552 0.456 0 0.936-0.192 1.296-0.552l9.144-10.152c0.912-1.008 1.44-2.256 1.512-3.576 0-0.312 0-0.624-0.024-0.912zM21.96 8.448c-0.048 0.864-0.408 1.68-1.008 2.328l-8.952 9.96-8.976-9.96c-0.6-0.672-0.96-1.488-1.008-2.304 0-0.24 0-0.456 0.024-0.672 0.192-2.52 2.328-4.56 4.848-4.632h0.168c1.632 0 3.168 0.792 4.104 2.112 0.192 0.264 0.48 0.408 0.816 0.408s0.624-0.144 0.816-0.408c0.984-1.368 2.592-2.16 4.272-2.112 2.52 0.096 4.68 2.112 4.896 4.632 0 0.216 0 0.432 0 0.648z"></path></svg>',
		'type2' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M23.856 9.168c-0.216-0.648-0.744-1.056-1.368-1.152l-6.216-0.912-2.76-5.664c-0.312-0.576-0.864-0.936-1.512-0.936-0.624 0-1.224 0.36-1.512 0.936l-2.784 5.664-6.216 0.912c-0.648 0.096-1.152 0.528-1.368 1.152s-0.048 1.32 0.456 1.776l4.464 4.368-1.080 6.168c-0.096 0.504 0.048 1.008 0.408 1.416 0.336 0.384 0.816 0.576 1.32 0.576 0.264 0 0.504-0.048 0.744-0.168l5.568-2.976 5.592 2.928c0.24 0.12 0.504 0.192 0.768 0.192 0.48 0 0.936-0.192 1.272-0.576 0.336-0.408 0.48-0.888 0.384-1.392l-1.056-6.216 4.464-4.368c0.48-0.432 0.648-1.080 0.432-1.728zM17.16 14.232c-0.216 0.216-0.336 0.552-0.288 0.864l1.056 6.096-5.448-2.856c-0.144-0.072-0.312-0.12-0.456-0.12-0.168 0-0.312 0.048-0.456 0.12l-5.496 2.832 1.056-6.048c0.072-0.336-0.048-0.672-0.288-0.888l-4.44-4.296 6.096-0.888c0.336-0.048 0.648-0.264 0.768-0.576l2.736-5.544 2.736 5.544c0.144 0.288 0.456 0.528 0.744 0.552l6.12 0.888-4.44 4.32z"></path></svg>',
		'none'  => ''
	),
);

$et_account_icons = array(
	'light' => array(
		'type1' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M16.848 12.168c1.56-1.32 2.448-3.216 2.448-5.232 0-3.768-3.072-6.84-6.84-6.84s-6.864 3.072-6.864 6.84c0 2.016 0.888 3.912 2.448 5.232-4.080 1.752-6.792 6.216-6.792 11.136 0 0.36 0.288 0.672 0.672 0.672h21.072c0.36 0 0.672-0.288 0.672-0.672-0.024-4.92-2.76-9.384-6.816-11.136zM12.432 1.44c3.048 0 5.52 2.472 5.52 5.52 0 1.968-1.056 3.792-2.76 4.776l-0.048 0.024c0 0 0 0-0.024 0-0.048 0.024-0.096 0.048-0.144 0.096h-0.024c-0.792 0.408-1.632 0.624-2.544 0.624-3.048 0-5.52-2.472-5.52-5.52s2.52-5.52 5.544-5.52zM9.408 13.056c0.96 0.48 1.968 0.72 3.024 0.72s2.064-0.24 3.024-0.72c3.768 1.176 6.576 5.088 6.816 9.552h-19.68c0.264-4.44 3.048-8.376 6.816-9.552z"></path></svg>',
		'none'  => ''
	),
	'bold'  => array(
		'type1' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M17.4 12.072c1.344-1.32 2.088-3.12 2.088-4.992 0-3.888-3.144-7.032-7.032-7.032s-7.056 3.144-7.056 7.032c0 1.872 0.744 3.672 2.088 4.992-3.792 1.896-6.312 6.216-6.312 10.92 0 0.576 0.456 1.032 1.032 1.032h20.52c0.576 0 1.032-0.456 1.032-1.032-0.048-4.704-2.568-9.024-6.36-10.92zM14.976 11.4l-0.096 0.024c-0.048 0.024-0.096 0.048-0.144 0.072l-0.024 0.024c-0.744 0.384-1.488 0.576-2.304 0.576-2.76 0-4.992-2.232-4.992-4.992s2.256-5.016 5.016-5.016c2.76 0 4.992 2.232 4.992 4.992 0 1.776-0.936 3.432-2.448 4.32zM9.456 13.44c0.936 0.456 1.944 0.672 2.976 0.672s2.040-0.216 2.976-0.672c3.336 1.104 5.832 4.56 6.192 8.52h-18.336c0.384-3.96 2.88-7.416 6.192-8.52z"></path></svg>',
		'none'  => ''
	)
);