<?php

namespace ETC\App\Controllers;

use ETC\App\Controllers\Base_Controller;

/**
 * Create customizer controller.
 *
 * @since      1.4.4
 * @package    ETC
 * @subpackage ETC/Models
 */
final class Customizer extends Base_Controller {
	
	/**
	 * Construct the class.
	 *
	 * @since 1.4.4
	 */
	public function hooks() {
		global $pagenow;

		if ( 'customize.php' === $pagenow || is_admin() || isset( $_REQUEST['wp_customize'] ) || isset( $_REQUEST['customize_theme'] ) ) {
			require_once ET_CORE_DIR . 'packages/kirki/kirki.php';
			require_once( ET_CORE_DIR . 'app/models/customizer/webfont-extend.php' );

			$_regenerate_xstore_kirki = get_option( 'xstore_kirki_styles_render', 'generate' );
			if ( 'generate' ===  $_regenerate_xstore_kirki ) {
				update_option( 'xstore_kirki_styles_render', 'regenerated' );
				add_action( 'init', array( $this, 'customizer_style' ), 11 );
			}
		} else {
			add_action( 'etheme_last_style', array( $this, 'xstore_kirki_enqueue' ) );
		}

		/**
		 * Load customize-builder.
		 *
		 * @since 1.4.3
		 */
		require_once( ET_CORE_DIR . 'app/models/customizer/class-ajax-search.php' );
		
		/**
		 * Load builder functions.
		 *
		 * @since 1.0.0
		 */
		require_once( ET_CORE_DIR . 'app/models/customizer/functions.php' );
		
		if ( 'customize.php' === $pagenow || is_admin() || isset( $_REQUEST['wp_customize'] ) || isset( $_REQUEST['customize_theme'] ) ) {
			/**
			 * Load customizer addons.
			 *
			 * @since 1.0.0
			 */
			require_once( ET_CORE_DIR . 'app/models/customizer/addons.php' );
			
			/**
			 * Customizer import/export plugin
			 *
			 * @since 2.1.4
			 */
			if ( ! defined( 'CEI_PLUGIN_DIR' ) ) {
				require_once( ET_CORE_DIR . 'packages/customizer-export-import/customizer-export-import.php' );
			}
		}

		// Enqueue frontend builder scripts
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ), 40 );
		
		add_action( 'init', array( $this, 'customizer_init' ) );

		add_filter( 'wp_resource_hints', array( $this, 'resource_hints' ), 10, 2 );

		add_action( 'customize_save_after', array( $this, 'customizer_style' ) );

	}
	
	/**
	 * Enqueue styles and scripts.
	 *
	 * @since 1.4.4
	 */
	public function enqueue_scripts() {
		
		wp_enqueue_style( 'etheme_customizer_frontend_css', ET_CORE_URL . 'app/models/customizer/frontend/css/etheme_builder-styles.css' );
		
		if ( get_option( 'etheme_single_product_builder', false ) ) {
			wp_enqueue_style( 'etheme_customizer_frontend_single_product_css', ET_CORE_URL . 'app/models/customizer/frontend/css/etheme_global-single-styles.css' );
		}
		
		if ( is_rtl() ) {
			wp_enqueue_style( 'etheme_customizer_frontend_rtl_css', ET_CORE_URL . 'app/models/customizer/frontend/css/etheme_builder-rtl-styles.css' );
		}
		
		wp_register_script( 'etheme_customizer_frontend_fancy_js', ET_CORE_URL . 'app/models/customizer/frontend/js/fancy.select.js' );
		
		// Register the script
		wp_register_script( 'etheme_customizer_frontend_js', ET_CORE_URL . 'app/models/customizer/frontend/js/frontend-script.min.js' );
		
		// Localize the script with new data
		$core = array(
			'ajaxurl'                => admin_url( 'admin-ajax.php' ),
			'noSuggestionNotice'     => __( 'No results were found.', 'xstore-core' ),
			'Product' 				 => esc_html__('Products', 'xstore-core'),
			'Pages' 				 => esc_html__('Pages', 'xstore-core'),
			'Post' 					 => esc_html__('Posts', 'xstore-core'),
			'Portfolio' 			 => esc_html__('Portfolio', 'xstore-core'),
			'woocommerce'            => class_exists( 'WooCommerce' ),
			'single_product_builder' => get_option( 'etheme_single_product_builder', false ),
			'fancy_select_categories' => function_exists('etheme_get_option')  && etheme_get_option('search_category_fancy_select_et-desktop', false),
			'ajaxProductNotify' 	 => function_exists('etheme_get_option') && etheme_get_option( 'ajax_added_product_notify', 1 )
		);
		
		wp_localize_script( 'etheme_customizer_frontend_js', 'etCoreConfig', $core );
		
		$depends = array( 'etheme' );
		
		// Enqueued script with localized data.
		if ( $core['fancy_select_categories'] ) {
			wp_enqueue_script( 'etheme_customizer_frontend_fancy_js', $depends );
			$depends[] = 'etheme_customizer_frontend_fancy_js';
		}
		wp_enqueue_script( 'etheme_customizer_frontend_js', $depends );
	}
	
	/**
	 * Initiate customizer options.
	 *
	 * @since 1.4.4
	 */
	public function customizer_init() {
		// Run builder
		$this->get_model()->_run();
	}
	
	/**
	 * Build css file from dynamic one.
	 *
	 * @since 3.0.1
	 */
	public function customizer_style( $file_name ) {
		if ( is_a( $file_name, 'WP_Customize_Manager' ) || '' == $file_name ) {
			$file_name = 'kirki-styles';
		}
		// Write stules to css file
		$this->get_model()->generate( $file_name );
	}

	/**
	 * Delete css file.
	 *
	 * @since 3.0.1
	 */
	public function delete_css_file( $file_name ) {
		// Delete css file
		$this->get_model()->delete( $file_name );
	}

	/**
	 * Enqueue xstore kirki styles.
	 *
	 * @since 3.0.1
	 */
	public function xstore_kirki_enqueue() {
		wp_enqueue_style(
			'xstore-kirki-styles',
			$this->get_model()->get_url(),
			array(),
			get_option( 'xstore_kirki_css_version', ET_CORE_VERSION ),
			'all'
		);
	}

	/**
	 * Add preconnect for Google Fonts.
	 *
	 * @access public
	 * @param array  $urls           URLs to print for resource hints.
	 * @param string $relation_type  The relation type the URLs are printed.
	 * @return array $urls           URLs to print for resource hints.
	 */
	public function resource_hints( $urls, $relation_type ) {
		$fonts_to_load = get_option( 'et_header_builder_fonts', false );

		if ( false === $fonts_to_load ) {
			return $urls;
		}

		if ( ! empty( $fonts_to_load ) && 'preconnect' === $relation_type ) {
			$urls[] = array(
				'href' => 'https://fonts.gstatic.com',
				'crossorigin',
			);
		}
		return $urls;
	}
}
